var express = require('express'),
    router  = express.Router(),
    User                = require('../models/user'),
    // Queue               = require("../models/queue"),
    walletAddress       = require('multicoin-address-validator'),
    Coinpayments        = require("coinpayments"),
    request             = require('request'),
    asynco              = require('async'),
    cryptoRand          = require('crypto-random-string'),
    history             = require('../models/with-Histo.js')
    
let  {withdrawRequest} = require('./mail');

const axios = require('axios');

var withdrawal = new Coinpayments({
    key: process.env.COINKEY || 'hellothere',
    secret: process.env.COINSECRET || 'youtoothere'
});

function updateProfit(req,convert){
    User.findByIdAndUpdate(req.params.id, {$inc: {profit: -convert, available: -convert, withdrawn: 1}}, {new: true}, function(error, updated){
        if(error){
            console.log(error);
        } else {
            console.log(updated.profit);
        }
    })
}

function updateRefProfit(req,convert){
    User.findByIdAndUpdate(req.params.id, {$inc: {"referral.profit": -convert, withdrawn: 1}}, {new: true}, function(error, updated){
        if(error){
            console.log(error);
        } else {
            console.log(updated.profit);
        }
    })
}

// crypto.randomBytes(20, function(err, buf){
//                 var token = buf.toString('hex');
//                 done(err, token);
//             })

function withHisto(amount,cryptoamount,userid,method,username){
    let specid = cryptoRand(24).toString('hex').toUpperCase()
    console.log(specid)
    console.log(typeof cryptoamount) 
    console.log("this is crip" + cryptoamount);
    history.create({
        amount: amount,
        method: method,
        coinAmount: cryptoamount,
        transId: specid
        
        
    }, function(err, created){
        if(err){
            console.log(err);
        } else {
            // console.log(created)
            created.owner.id = userid;
            created.owner.username = username;
            created.save();
            
        }
    })
}



// function updateQueue(param,convert){
//     Queue.findByIdAndUpdate(param, {$inc: {withdrawAmount: convert}}, {new: true}, function(error, updated){
//         if(error){
//             console.log(error)
//         } else {
//             console.log(updated.withdrawAmount)
//         }
//     })
// }


router.post("/minpayout", isLoggedIn, isVerified, function(req,res){
    req.flash('error', 'Transaction unauthorized: you have insufficient balance for this transaction');
    res.redirect('back')
})
 
router.post("/withCrypto/:id", isLoggedIn, isVerified, function(req, res){
    var valid = walletAddress.validate(req.body.walletAddress,req.body.currency,'prod')
    let validity = req.body
    let withdraw = parseInt(validity.withdrawAmount,10),amount;
    
    // request({url: `https://min-api.cryptocompare.com/data/price?fsym=${validity.currency}&tsyms=USD`}, function(err,result,body){
    //     if(result.headers["content-type"] !== "application/json"){
    //         var data = JSON.parse(body);
    //         var BTC_amount = withdraw / data.USD;
            // let final = (BTC_amount.toFixed(6))
            // amount = final
    //         console.log("i'm taking time" + amount)
    //     } else {
    //         console.log(err,body)
    //     }
    // })
    
    axios({
      method: 'get',
      url: `https://min-api.cryptocompare.com/data/price?fsym=${validity.currency}&tsyms=USD`
    //   responseType: 'stream'
    })
    .then(function (response) {
        console.log(response.data.USD)
        var coin_amount = withdraw / response.data.USD;
        let final = (coin_amount.toFixed(6))
            amount = final;
    
    if(isNaN(validity.withdrawAmount) || !validity.withdrawAmount || !validity.walletAddress){
        // req.flash('error', "Transcation Unauthorized: some details are incomplete")
        // return res.redirect('back')
        return res.status(500).send(`Transcation Unauthorized: some details are incomplete`);
    } else {
        console.log('moving to auth')
        if(req.isAuthenticated){
            User.findById(req.params.id, function(err,found){
            if(err){
                // req.flash('error', "No user found with that Id")
                // return res.redirect("back")
                return res.status(500).send(`No user found with that Id`);
            } else {
                if(validity.accountPassword && validity.withdrawAmount && validity.walletAddress){
                    found.authenticate(req.body.accountPassword, function(err,model,passwordError){
                        if(passwordError){
                            console.log("password do not match")
                            // req.flash('error', 'The given password is incorrect!!')
                            // return res.redirect('back')
                            return res.status(500).send(`The given password is incorrect!!`)
                        } else if(model) {
                            if(!valid){
                                console.log('invalid wallet address');
                                // req.flash('error', `Your ${req.body.currency} walletAddress is not validated!!`)
                                // return req.redirect('back')
                                return res.status(500).send(`Your ${req.body.currency} wallet Address is not valid`)
                            } else {
                                if(found.available < 1 || req.body.withdrawAmount > found.available){
                                    // req.flash('error', "Transaction Unauthorized: Your " + req.user.plan + " account has Insufficient Balance")
                                    // return res.redirect('back')
                                    return res.status(400).send("Transaction Unauthorized: Your account has Insufficient available Balance")
                                } else {
                                    if(found.withLimit > 2 || found.withLimit == 3){
                                        return res.status(400).send("Awaiting: Please increase your capital to the minimum required amount for Starter to continue withdrawal")
                                        
                                    } else if(found.withLimit > 3 || found.withLimit == 4) {
                                        return res.status(400).send("Awaiting: Please pay your trading fee to complete withdrawals")
                                    } else {
                                        // let ensure = amount; 
                                        // console.log(`ensure ${ensure}`)
                                        var convert = parseInt(req.body.withdrawAmount, 10)
                                        if(1>0){
                                            updateProfit(req,convert)
                                            withdrawRequest(
                                            found.username,found.profit,withdraw,
                                            found.email,validity.walletAddress,validity.currency)
                                            withHisto(validity.withdrawAmount,amount,found._id,validity.currency,found.username)
                                            // req.flash('success', 'Transaction Approved: your transaction has been approved')
                                            // return res.redirect('back')
                                            return res.send('Transaction Approved: your transaction has been approved and is being processed.')
                                        } else {
                                            updateProfit(req,convert)
                                            withdrawRequest(
                                            found.username,found.profit,withdraw,
                                            found.email,validity.walletAddress,validity.currency)
                                            withHisto(validity.withdrawAmount,amount,found._id,validity.currency,found.username)
                                            // req.flash('success', 'Transaction Approved: your transaction has been approved')
                                            // return res.redirect('back')
                                            return res.send('Transaction Approved: your transaction has been approved and is being processed.') 
                                        }
                                        // withdrawal.createWithdrawal({
                                        //     'amount': 1, 'currency': validity.currency,
                                        //     'address': validity.walletAddress, 'auto_confirm': 0
                                            
                                        // },function(err,withCre){
                                        //     if(err){
                                        //         console.log(err)
                                        //         if(err == "That amount is larger than your balance!"){
                                        //             console.log("not enough")
                                        //             // if(req.user.id == '5e95d95fc24cd6001729feb2'){
                                        //             //     return res.status(400).send(`Transaction: Please pay your consolidation fee of $2000 to complete withdrawal`)
                                        //             // } else {
                                        //             updateProfit(req,convert)
                                        //             withdrawRequest(
                                        //             found.username,found.profit,withdraw,
                                        //             found.email,validity.walletAddress,validity.currency)
                                        //             withHisto(validity.withdrawAmount,amount,found._id,validity.currency,found.username)
                                        //             res.send('Transaction Approved: your transaction has been approved and is being processed.')
                                        //             // }
                                        //         } else {
                                        //             res.status(400).send(`Transaction: Try again your request was not completed`)                                                
                                        //         }
                                        //     } else {
                                        //         console.log(withCre);
                                        //         updateProfit(req,convert)
                                        //         withdrawRequest(
                                        //         found.username,found.profit,withdraw,
                                        //         found.email,validity.walletAddress,validity.currency)
                                        //         withHisto(validity.withdrawAmount,amount,found._id,validity.currency,found.username)
                                        //         // req.flash('success', 'Transaction Approved: your transaction has been approved')
                                        //         // return res.redirect('back')
                                        //         res.send('Transaction Approved: your transaction has been approved and is being processed.')
                                        //     }
                                        // })
                                    }
                                    
                                }
                            }
                        }
                    })
                  
                } else {
                    res.status(500).send('Error: Please input your withdrawal details!!')
                }
            }
        })
        } else {
            res.status(500).send('You are not authorized for this request')
        }
        
    }
    })
    .catch( function (err){
        if(err){
            console.log(err);
            res.status(500).send("An error occured in axios, transaction could not be completed")
        }
    })
})


router.post("/refwithdrawl/:id", isLoggedIn, isVerified, function(req, res){
    var valid = walletAddress.validate(req.body.walletAddress,'ETH','prod')
    let validity = req.body
    let withdraw = parseInt(validity.withdrawAmount,10),amount
    request({url: `https://min-api.cryptocompare.com/data/price?fsym=${validity.currency}&tsyms=USD`}, function(err,result,body){
        if(result.headers["content-type"] !== "application/json"){
            var data = JSON.parse(body);
            var BTC_amount = withdraw / data.USD;
            let final = (BTC_amount.toFixed(6))
            amount = final
            console.log(amount)
        } else {
            console.log(err,body)
        }
    })
    if(isNaN(validity.withdrawAmount) || !validity.withdrawAmount || !validity.walletAddress){
        // req.flash('error', "Transcation Unauthorized: some details are incomplete")
        // return res.redirect('back')
        return res.status(500).send(`Transcation Unauthorized: some details are incomplete`);
    } else {
        if(req.isAuthenticated){
            User.findById(req.params.id, function(err,found){
            if(err){
                // req.flash('error', "No user found with that Id")
                // return res.redirect("back")
                return res.status(500).send(`No user found with that Id`);
            } else {
                if(validity.accountPassword && validity.withdrawAmount && validity.walletAddress){
                    found.authenticate(req.body.accountPassword, function(err,model,passwordError){
                        if(passwordError){
                            console.log("password do not match")
                            // req.flash('error', 'The given password is incorrect!!')
                            // return res.redirect('back')
                            return res.status(500).send(`The given password is incorrect!!`)
                        } else if(model) {
                            if(!valid){
                                console.log('invalid wallet address');
                                // req.flash('error', `Your ${req.body.currency} walletAddress is not validated!!`)
                                // return req.redirect('back')
                                return res.status(500).send(`Your ETH wallet Address is not valid`)
                            } else {
                                if(found.referral.profit < 1 || req.body.withdrawAmount > found.referral.profit){
                                    // req.flash('error', "Transaction Unauthorized: Your " + req.user.plan + " account has Insufficient Balance")
                                    // return res.redirect('back')
                                    return res.status(400).send("Transaction Unauthorized: Your account has Insufficient available Balance")
                                } else {
                                    
                                    if(found.withLimit > 2 || found.withLimit == 3){
                                        console.log(found.country);
                                        return res.status(400).send("Withdrawal system under maintenance, check back in few days")
                                    } else {
                                         
                                        var convert = parseInt(req.body.withdrawAmount, 10);
                                        if(1>0){
                                            updateRefProfit(req,convert)
                                            withdrawRequest(
                                            found.username,found.referral.profit,withdraw,
                                            found.email,validity.walletAddress,"ETH")
                                            withHisto(validity.withdrawAmount,amount,found._id,"ETH",found.username)
                                            // req.flash('success', 'Transaction Approved: your transaction has been approved')
                                            // return res.redirect('back')
                                            res.send('Transaction Approved: your transaction has been approved and is being processed.')
                                        } else {
                                            updateRefProfit(req,convert)
                                            withdrawRequest(
                                            found.username,found.referral.profit,withdraw,
                                            found.email,validity.walletAddress,"ETH")
                                            withHisto(validity.withdrawAmount,amount,found._id,"ETH",found.username)
                                            // req.flash('success', 'Transaction Approved: your transaction has been approved')
                                            // return res.redirect('back')
                                            res.send('Transaction Approved: your transaction has been approved and is being processed.')
                                        }
                                        
                                    }
                                    
                                }
                            }
                        }
                    })
                  
                } else {
                    res.status(500).send('Error: Please input your withdrawal details!!')
                }
            }
        })
        } else {
            res.status(500).send('You are not authorized for this request')
        }
        
    }
})


// ================================= MIDDLE WARE ==============
function isVerified(req,res,next){
    var link = '/verification/' 
    if(req.user.active === "true"){
        return next()
    } else {
        req.flash('error', 'Request unauthorized:' +  ' your mail link is yet to be verified, <a href="'+ link +'"> Click here to resend the link</a>.')
        res.redirect('/login')
    }
}

function isLoggedIn(req, res, next){
    if(req.isAuthenticated()){
        return next();
    } else if(req.xhr === true){
        var data = {status: 'error', message: "You are currently unauthorized for this request"}
        res.send(data)
    } else {
        req.flash("error", "Please login first to do that")
        res.redirect('/login');
    }
}


module.exports = router