let g2fa                  = require('../models/g2fa'),
    TopStrategy           = require('passport-totp').Strategy,
    base32                = require('thirty-two'),
    express               = require('express'),
    passport              = require('passport'),
    User                  = require('../models/user'),
    router                = express.Router()
    
    
passport.use(new TopStrategy(function(user,done){
    console.log('request entered into pasport')
    console.log(`identified user ${user}`)
    g2fa.findOne({'id': user._id}, function(err, user){
		if (err) {
		    console.log(err)
			return done(err);
		} else if(user){
		    return done(null, user.secret, 30);
		} else {
		    console.log('user not found')
		    return done('User not found, please scan the qrImage to continue')
		}
	});
}));

router.get('/2facheck/:id', isLoggedIn, function(req,res){
    console.log(req.user._id)
    g2fa.find({id: req.user._id}, function(err,user){
        if(err)console.log(err)
        console.log(`user ${user}`)
        if(user.length < 1){
            if(req.xhr === true){
                return res.status(500).send({url: '/setup2fa', message: `please setup two factor authenticator to continue`});
            }
        } else {
            if(req.xhr == true){
                return res.send({url: `/login-otp/${req.user._id}`});
            } else {
                // req.flash('error', 'Authenticate two factor to continue');
                return res.render('login2fa')
            }
        }
    })
});


router.get('/setup2fa/:id', isLoggedIn, function(req,res){
    g2fa.findOne({id: req.params.id}, (err,resu) =>{
        console.log('request came in')
        if(err){
            console.log(err)
        } else if(resu && req.user.twofactor == false){
            let secret;
            secret = genSecret(10).toUpperCase();
			var encodedKey = base32.encode(secret);
			console.log(encodedKey);
			resu.secret = secret;
			resu.save(function(err,tok){
                if(err){
                    console.log(err);
                } else {
        			var otpUrl = 'otpauth://totp/Bitthedge?secret=' + encodedKey + '&period=30';
        			var qrImage = 'https://chart.googleapis.com/chart?chs=166x166&chld=L|0&cht=qr&chl=' + encodeURIComponent(otpUrl);
                    let decode = base32.decode(encodedKey);
                    console.log(decode.toString())
                    let twofakey = encodedKey.toString();
                    return res.send({key: twofakey, qrImage: qrImage});
                }
			});
            
        } else if(resu && req.user.twofactor == true){
            res.status(500).send('Your account has already been setup with Two Factor authentication');
        } else {
            console.log('working on a new user')
            User.findOne({_id: req.params.id}, function(err,user){
                if(err){
                    console.log(err)
                    return res.status(500).send('Unauthorized: user not Identified');
                } else if(user) {
                    let secret;
                    secret = genSecret(10).toUpperCase();
        			var encodedKey = base32.encode(secret);
        			var newToken = new g2fa({username: req.user.username, id: req.user.id, secret: secret});
        			newToken.save(function(err,tok){
                        if(err){
                            console.log(err)
                        } else {
                            console.log(" New user " + tok);
                			var otpUrl = 'otpauth://totp/Bitthedge?secret=' + encodedKey + '&period=30';
                			var qrImage = 'https://chart.googleapis.com/chart?chs=166x166&chld=L|0&cht=qr&chl=' + encodeURIComponent(otpUrl);
                            let twofakey = encodedKey.toString();
                            return res.send({key: twofakey, qrImage: qrImage});
                        }
        			});
                }
            })
        }
    })
})

router.get('/failedAuthenticate', (req,res)=>{
    if (req.session.secondFactor) {
		res.status(500).send('Account already authenticated')
	} else {
	    res.status(500).send('Authentication code incorrect or time sync incorrect')
	}
})

router.post('/login-otp/:id', isLoggedIn,
    passport.authenticate('totp', { failureRedirect: '/failedAuthenticate', failureFlash: true }),
    function(req, res) {
        req.session.secondFactor = 'totp';
        User.findByIdAndUpdate(req.params.id, {$set: {twofactor: true}}, function(err,user){
            if(err)console.log(err)
            res.send({message: 'Authenticated successfully!'});
        })
        // delete req.session.secondFactor
});

router.post('/disable-otp/:id', isLoggedIn,
    passport.authenticate('totp', { failureRedirect: '/failedAuthenticate', failureFlash: true }),
    function(req, res) {
        delete req.session.secondFactor;
        req.session.secondFactor = 'totp';
        User.findByIdAndUpdate(req.params.id, {$set: {twofactor: false}}, function(err,user){
            if(err)console.log(err)
            res.send({message: '2FA Disabled successfully'});
        })
});

function getRandomInt(min, max) {
	return Math.floor(Math.random() * (max - min + 1)) + min;
}

function genSecret(len) {
	var buf = []
	, chars = 'abcdefghijklmnopqrstuvwxyz0123456789'
	, charlen = chars.length;

	for (var i = 0; i < len; ++i) {
		buf.push(chars[getRandomInt(0, charlen - 1)]);
	}

	return buf.join('');
};


router.get('/restore-2fa_idint_h6kl', isLoggedIn, function(req,res){
    res.render('restore2fa');
})

router.post('/restore-2fa_idint_h6kl/:id', isLoggedIn, function(req,res){
    let password = req.query.password,
          authkey  = req.query.authKey
    console.log(req.query);
    
    if(password && authkey){
        User.findById(req.params.id, function(err, found){
            if(err){
                console.log(err)
                res.status(400).send('No user found with this Id')
            } else {
                found.authenticate(password, function(err,model,passwordError){
                    if(passwordError){
                        res.status(400).send('The given password is incorrect!!')
                    } else if(model){
                        let decode = base32.decode(authkey).toString();
                        console.log(`decoded key ${decode}`); 
                        g2fa.findOne({secret: decode}, function(err,found){
                            console.log(found);
                            if(err){
                                console.log(err)
                                return res.status(400).send('An error occured')
                            } else if(!found){
                                return res.status(400).send('Authentication key not found');
                            } else if(found){
                                console.log(found.username)
                                let secret;
                                secret = genSecret(10).toUpperCase();
                    			console.log(`new secret: ${secret}`)
                    			var encodedKey = base32.encode(secret);
                    			console.log(encodedKey)
                    			found.secret = secret;
                    			found.save(function(err,tok){
                                    if(err){
                                        console.log(err)
                                    } else {
                                        console.log(tok);
                            			var otpUrl = 'otpauth://totp/bitthedge?secret=' + encodedKey + '&period=30';
                            			var qrImage = 'https://chart.googleapis.com/chart?chs=166x166&chld=L|0&cht=qr&chl=' + encodeURIComponent(otpUrl);
                                        let decode = base32.decode(encodedKey);
                                        console.log(decode.toString())
                                        let twofakey = encodedKey.toString();
                                        return res.send({key: twofakey, qrImage: qrImage});
                                    }
                    			});
                                
                            }
                        })
                        
                    }
                })
            }
        })
    } else {
        res.status(400).send('Some credentials are missing')
    }
})

function isLoggedIn(req, res, next){
    if(req.isAuthenticated()){
        return next();
        // if(req.user.twofactor == true){
        //     if(req.session.secondFactor){
        //         return next();
        //     } else {
        //         if(req.xhr === true){
        //             return res.status(500).send('Authenticate two factor to continue');
        //         }
        //         req.flash('error', 'Authenticate two factor to continue')
        //         return res.redirect(`/2facheck/${req.user._id}`)
        //     }
        // } else {
        //     return next();
        // }
    }
    if(req.xhr === true){
        return res.status(500).send('Please login first to do that');
    } else {
        req.flash("error", "Please login first to do that")
        return res.redirect('/login');
    }
}

    
module.exports = {router}