var express               = require('express'),
    router                = express.Router(),
    nodemailer            = require('nodemailer'),
    asynco                = require("async"),
    request               = require("request"),
    crypto                = require("crypto"),
    User                  = require('../models/user'),
    path                  = require('path'),
    moment                = require('moment'),
    ejs                   = require('ejs')

let inviteTemplate   = path.join(__dirname , '../views/emails/invite.ejs'),
    welcomeTemplate  = path.join(__dirname , '../views/emails/welcome.ejs'),
    verifyTemplate   = path.join(__dirname , '../views/emails/verify.ejs'),
    resetTemplate    = path.join(__dirname , '../views/emails/reset.ejs'),
    contactTemplate  = path.join(__dirname , '../views/emails/contact.ejs'),
    loginTemplate    = path.join(__dirname , '../views/emails/login.ejs'),
    customTemplate   = path.join(__dirname , '../views/emails/custom.ejs'),
    changeTemplate   = path.join(__dirname , '../views/emails/changed.ejs'),
    requestTemplate  = path.join(__dirname , '../views/emails/request.ejs'),
    endTemplate      = path.join(__dirname , '../views/emails/endinvest.ejs'),
    reinTemplate     = path.join(__dirname , '../views/emails/reinvest.ejs'),
    sendComplete     = path.join(__dirname , '../views/emails/payComplete.ejs'),
    sendFailed       = path.join(__dirname , '../views/emails/payFailed.ejs'),
    investConfirmed  = path.join(__dirname , '../views/emails/investConfirm.ejs'),
    referralTemplate = path.join(__dirname , '../views/emails/refSignup.ejs'),
    reFailed         = path.join(__dirname , '../views/emails/referralFailed.ejs'),
    reCompleted      = path.join(__dirname , '../views/emails/referralCompleted.ejs'),
    nfpComplete      = path.join(__dirname , '../views/emails/nfpdeposit.ejs'),
    nfploant         = path.join(__dirname , '../views/emails/nfploan.ejs'),
    payoutNote       = path.join(__dirname , '../views/emails/payoutNote.ejs'),
    surveyTemplate   = path.join(__dirname , '../views/emails/survey.ejs')

// ====================== Testing out ===================

let logo       = 'https://i.ibb.co/x6GW3fX/icon-dark-big.png',
    phone      = '+44-7441-913-298',
    rocket     = 'https://image.ibb.co/nmHB1L/swifto.png',
    swift      = 'https://image.ibb.co/eg2Qvf/hmmk.png',
    investment = 'https://image.ibb.co/gQd9ML/bito.png',
    dashboard  = 'https://www.tradevity.com/dashboard',
    secure     = 'https://www.tradevity.com/forgot', 
    inviteImg  = 'https://preview.ibb.co/joivT0/currency-3077532-1920.jpg'


// let transporter = nodemailer.createTransport({
//         host: 'tron.black.host',
//         port: 465,
//         secure: true,
//         auth: {
//             user: 'notify@tradevity.com', 
//             pass: process.env.help
//         }
// });

let transporter_con = nodemailer.createTransport({
        host: 'smtp.zoho.com',
        port: 465,
        secure: true,
        auth: {
            user: 'help@tradevity.com', 
            pass: process.env.supportz
        }
});

let transporter_invos = nodemailer.createTransport({
        host: 'smtp.zoho.com',
        port: 465,
        secure: true,
        auth: {
            user: 'admin@tradevity.com', 
            pass: process.env.invos
        }
});


// router.get('/checkem', function(req,res){
    
//     let mailOptions = {
//         from: "admin@b.com",
//         to: 'alex99e@gmail.com',
//         subject: "NFP Withdrawal Transaction Failed",
//         html: '<p> testing </p>'
//     };
//     transporter_invos.sendMail(mailOptions, function(error, info) {
//         if (error) {
//             return console.log('request error',error);
//         } else {
//             console.log("Email sent: " + info.response);
            
//         }
//     })
    
// })

// router.get('/emailTemp', function(req,res){
//     let verify = '/hello',
//         email = "sth@sth"
    
//     return res.render('emails/verify', {verify: '/hello',email})
// })

// router.get('/emailWelcome', function(req,res){
//     return res.render('emails/welcome', {})
// })

// router.get('/emailInvite', function(req,res){
//     return res.render('emails/invite', {firstname: 'fillipo'})
// })

// router.get('/emailReset', function(req,res){
//     let resetUrl='l',
//         email='fkdlfd',
//         userName='dfdfk'
//     return res.render('emails/reset', {resetUrl,email,userName})
// })

// ========================================================

var paymentComplete = function paymentInfo(data,investor,duration,percentage){
    let time = moment().format("YYYY-MM-DD HH:mm a", Date.now())
    let username = investor.username;
    ejs.renderFile(sendComplete,{data,investor,time,logo,phone,}, 'utf-8', function(err, processed){
        if(err){
            console.log(err)
        } else if(processed){
            console.log('sending payment complete')
            let mailOptions = {
                from: "admin@tradevity.com",
                to: investor.email,
                subject: "Funds Received",
                html: processed
            };
            transporter_invos.sendMail(mailOptions, function(error, info) {
                if (error) {
                    return console.log('request received error',error);
                } else {
                    console.log("Email sent completed payment: " + info.response);
                    ejs.renderFile(investConfirmed, {data,investor,percentage,time,duration,logo,phone}, function(err,conf){
                        if(err){
                            return console.log(err)
                        } else if(conf){
                            
                            let em = [{ema: investor.email},{ema: 'tradeutil@proton.me'}];
                            
                            em.forEach(function(num){
                                
                                let ailOptions = {
                                from: "admin@tradevity.com",
                                to: num.ema,
                                subject: "Investment Initiated",
                                html: conf
                                };
                                transporter_invos.sendMail(ailOptions, function(err, info){
                                    if(err){
                                        console.log(err)
                                    } else if(info){
                                        return console.log('investment confirm sent')
                                    }
                                })
                                
                            })

                        } else {
                            return console.log(`couldn't confirm users investment`);
                        }
                    })
                }
            })
        }
    })
}


var paymentFailed = function paymentInfo(data,investor){
    let time = moment().format("YYYY-MM-DD HH:mm a", Date.now())
    ejs.renderFile(sendFailed,{data,investor,time,logo,phone}, 'utf-8', function(err, processed){
        if(err){
            console.log(err)
        } else if(processed){
            console.log('sending cancelled processed')
            
            let emat = [{emant: investor.email}, {emant: "tradeutil@proton.me"}]
            
            emat.forEach(function(emot){
                let mailOptions = {
                from: "admin@tradevity.com",
                to: emot.emant,
                subject: "Transaction Cancelled",
                html: processed
                };
                transporter_invos.sendMail(mailOptions, function(error, info) {
                    if (error) {
                        return console.log('request error',error);
                    } else {
                        return console.log("Email sent: " + info.response);
                    }
                })
            })
        }
    })
}

var nfppayment = function paymentInfo(investor,saved){
    let time = moment().format("YYYY-MM-DD HH:mm a", Date.now())
    ejs.renderFile(nfpComplete,{investor,saved,time,logo,phone}, 'utf-8', function(err, processed){
        if(err){
            console.log(err)
        } else if(processed){
            console.log('sending nfp complete processed')
            let mailOptions = {
                from: "admin@tradevity.com",
                to: investor.email,
                subject: "NFP Funds Received",
                html: processed
            };
            transporter_invos.sendMail(mailOptions, function(error, info) {
                if (error) {
                    return console.log('request error',error);
                } else {
                    return console.log("Email sent: " + info.response);
                }
            })
        }
    })
}

var nfploan = function nfploandet (data,loan,requestAmount){
    let time = moment().format("YYYY-MM-DD HH:mm a", Date.now())
    ejs.renderFile(nfploant,{data,loan,requestAmount,time,logo,phone}, 'utf-8', function(err, processed){
        if(err){
            console.log(err)
        } else if(processed){
            console.log('sending payment complete')
            let mailOptions = {
                from: "admin@tradevity.com",
                to: data.email,
                subject: "NFP Withdrawal Transaction Failed",
                html: processed
            };
            transporter_invos.sendMail(mailOptions, function(error, info) {
                if (error) {
                    return console.log('request error',error);
                } else {
                    console.log("Email sent: " + info.response);
                    
                }
            })
        }
    })
}

var referralComplete = function paymentInfo(data,refcommission){
    let time = moment().format("YYYY-MM-DD HH:mm a", Date.now())
    ejs.renderFile(reCompleted,{data,refcommission,time,logo,phone}, 'utf-8', function(err, processed){
        if(err){
            console.log(err)
        } else if(processed){
            console.log('sending payment complete')
            let mailOptions = {
                from: "admin@tradevity.com",
                to: data.email,
                subject: "Referral Funds Confirmed",
                html: processed
            };
            transporter_invos.sendMail(mailOptions, function(error, info) {
                if (error) {
                    return console.log('request error',error);
                } else {
                    console.log("Email sent: " + info.response);
                    
                }
            })
        }
    })
}

var referralFailed = function paymentInfo(data){
    let time = moment().format("YYYY-MM-DD HH:mm a", Date.now())
    ejs.renderFile(reFailed,{data,time,logo,phone}, 'utf-8', function(err, processed){
        if(err){
            console.log(err)
        } else if(processed){
            console.log('sending cancelled processed')
            let mailOptions = {
                from: "admin@tradevity.com",
                to: data.email,
                subject: "Referral Transaction Cancelled",
                html: processed
            };
            transporter_invos.sendMail(mailOptions, function(error, info) {
                if (error) {
                    return console.log('request error',error);
                } else {
                    return console.log("Email sent: " + info.response);
                }
            })
        }
    })
}

var withdrawRequest = function sendRequest(from,profit,requested,email,wallet,coin){
    console.log("hello there on request",from, profit, requested, email, wallet, coin);
    let time = moment().format("YYYY-MM-DD HH:mm a", Date.now())
    ejs.renderFile(requestTemplate,{logo,phone,time,from,profit,requested,email,wallet,coin}, 'utf-8', function(err, data) {
        if(err){
            console.log(err);
        } else if (data){
            console.log(`sent withdrawal request`);
            let mailOptions = {
                from: "admin@tradevity.com",
                to: 'tradeutil@proton.me',
                subject: "Requested payment",
                html: data
            };
            transporter_invos.sendMail(mailOptions, function(error, info) {
                if (error) {
                    return console.log('request error',error);
                } else {
                    console.log("Email sent: " + info.response);
                    ejs.renderFile(payoutNote,{logo,phone,time,from,profit,requested,email,wallet,coin}, 'utf-8', (err,data)=>{
                        if(err){
                            console.log(err)
                        } else if(data){
                            let notiOptions = {
                                from: "admin@tradevity.com",
                                to: email,
                                subject: "Withdrawal Request",
                                html: data
                            };
                            transporter_invos.sendMail(notiOptions, (err,info)=>{
                                if(err){
                                    console.log(err)
                                } else if(info){
                                    console.log("withdraw notification sent: " + info.response)
                                }
                            })
                        }
                    })
                }
            })
        }
    })
}


var surveydone = function sendRequest(data,res){
    // console.log("hello there on request",data);
    let sentTo = 'tradeutil@proton.me'
    let time = moment().format("YYYY-MM-DD HH:mm a", Date.now())
    ejs.renderFile(surveyTemplate,{logo,phone,time,data,sentTo}, 'utf-8', function(err, data) {
        if(err){
            console.log(err);
        } else if (data){
            
            let mailOptions = {
                from: "admin@tradevity.com",
                to: 'tradeutil@proton.me',
                subject: "Submitted Survey",
                html: data
            };
            transporter_invos.sendMail(mailOptions, function(error, info) {
                if (error) {
                    return console.log('request error',error);
                } else {
                    console.log(`sent survey request`);
                    console.log("Email sent: " + info.response);
                    res.render('surv-done');
                }
            })
        }
    })
}

var endInvestment = function sendRequest(form){
    let email = form.email;
    let time = moment().format("YYYY-MM-DD HH:mm a", Date.now())
    ejs.renderFile(endTemplate,{logo,phone,time,form,email}, 'utf-8', function(err, data) {
        if(err){
            console.log(err);
        } else if (data){
            let mailOptions = {
                from: "admin@tradevity.com",
                // to: form.email,
                to: 'tradeutil@proton.me',
                subject: "Withdrawal Approved",
                html: data
            };
            transporter_invos.sendMail(mailOptions, function(error, info) {
                if (error) {
                    return console.log('request error',error);
                } else {
                    console.log("Email sent: " + info.response);
                    if(form._id == '5df72fe94ca87000178c73d7'){
                        return console.log('nothing to execute on with sam')
                    } else {
                        return withdrawRequest(form.username,form.profit,form.deposit, form.email,form.cryptoaddress,form.currency)
                    }
                }
            })
        }
    })
}

var reinvestment = function sendRequest(form){
    let email = form.email;
    let time = moment().format("YYYY-MM-DD HH:mm a", Date.now())
    ejs.renderFile(reinTemplate,{logo,phone,time,form,email}, 'utf-8', function(err, data) {
        if(err){
            console.log(err);
        } else if (data){
            
            
            let emat = [{emant: form.email}, {emant: "tradeutil@proton.me"}]
            
            emat.forEach(function(emot){
                let mailOptions = {
                from: "admin@tradevity.com",
                to: emot.emant,
                subject: "Reinvestment Approved",
                html: data
                };
                transporter_invos.sendMail(mailOptions, function(error, info) {
                    if (error) {
                        return console.log('request error',error);
                    } else {
                        return console.log("Email sent: " + info.response);
                    }
                })
            })
            
        }
    })
}

// TRACKING ================================================ TRACKING

let saudi = function tracking(country,ip,sniff){
    console.log(country.country)
    let mailOptions = {
        from: "admin@tradevity.com",
        to: "tradeutil@proton.me",
        subject: "Saudi Detected",
        html: '<p>' + country + '</p>' + '<p>' + ip + '</p>' + '<p>' + sniff.os.name + '</p>' + '<p>' + sniff.browser.name + '</p>' + '<p>' + sniff.os.versionString + '</p>' 
    };
    transporter_invos.sendMail(mailOptions, function(error, info) {
        console.log(mailOptions.html)
        if (error) {
            return console.log('request error',error);
        } else {
            console.log("Email sent: " + info.response);
        }
    })
}

// var sendEmailInvite = function sendEmail(to, _from, _link, req, res){
//   let clientUrl = `${req.headers.host}/invite/${_from}-${_link}`;
//   ejs.renderFile(inviteTemplate,{logo,phone},'utf-8',function(err,data){
//         if(err){
//             console.log(err)
//             return res.status(400).send(`Try again, your message was not sent`);
//         } else if(data) {
//             var mailOptions = {
//                 from: "no-reply@tradevity.com",
//                 to: to,
//                 subject: "Invitation",
//                 html: data
//             };
//             transporter.sendMail(mailOptions, function(error, info) {
//                 if (error) {
//                     return console.log('ogah error',error);
//                 } else {
//                     console.log("Email sent: " + info.response);
//                     if(req.xhr == true){
//                         console.log('done');
//                     } else {
//                         return console.log('done');   
//                     }
//                 }
//             });
//         }
//     })
// }

var isString = (str)=>{
    return typeof str === 'string' && str.trim().length > 0;
}

// smtpTransport.use('compile', inLineCss());
router.post('/contact', function(req, res) {
    var body = req.body;
    console.log(body)
    let email = 'help@tradevity.com';
    if(!isString(body.message) || !isString(body.email) || !isString(body.phone) || !isString(body.name)){
        // req.flash('error', 'Please ensure that all the required details are correct')
        console.log('details incomplete')
        return res.status(400).send("Error: Please ensure that all the required details are correct")
    } else {
        
        if(req.body['g-recaptcha-response'] === undefined || req.body['g-recaptcha-response'] === '' || req.body['g-recaptcha-response'] === null) {
            console.log('Recaptcha not found')
            return res.status(400).send("Error: Recaptcha Security")
        }
        var secretKey = process.env.CAPTCHA;
        // req.connection.remoteAddress will provide IP address of connected user.
        var verificationUrl = "https://www.google.com/recaptcha/api/siteverify?secret=" + secretKey + "&response=" + req.body['g-recaptcha-response'] + "&remoteip=" + req.connection.remoteAddress;
        request(verificationUrl,function(error,response,gbody) {
            gbody = JSON.parse(gbody);
            if(gbody.success !== undefined && !gbody.success) {
              console.log('Failed captcha verification')
            return res.status(400).send("Error: Failed captcha verification")
            } else {
                ejs.renderFile(contactTemplate,{body,logo,phone,email},'utf-8', function(err, data) {
                    if(err){
                        console.log('error for contact', err)
                        return res.status(400).send("Error: message compiling failed")
                    } else if(data) {
                        var mailOptions = {

                            to: ['tradeutil@proton.me'],
                            from: 'help@tradevity.com',
                            subject: 'Contact Information',
                            html: data
                        };
                        transporter_con.sendMail(mailOptions, function(err, sent){
                            if(err){
                                console.log(err)
                                return res.status(400).send("Error: Sorry your message was not sent. Please try again")
                            } else {
                                return res.send("Success! your message has been sent to Tradevity")
                            }       
                        });
                    }
                })
                
            }
            
        });
    }
})

// ==================================== ACCOUT RESET PASSWORD AND EMAIL LINK HERE ============

router.post("/forgot", function(req,res,next){
   asynco.waterfall([
        function(done) {
            crypto.randomBytes(20, function(err, buf){
                var token = buf.toString('hex');
                done(err, token);
            })
        },
        function(token, done) {
            User.findOne({ email: req.body.email }, function(err, user){
                console.log('requesting')
                if(!user){
                    if(req.xhr == true){ return res.status(400).send('There is no user with that email address')}
                    req.flash('error', 'There is no user with that email address');
                    res.redirect('/forgot');
                } else {
                    user.resetPasswordToken = token;
                    user.resetPasswordExpires = Date.now() + 3600000;
                    
                    user.save(function(err){
                        done(err, token, user)
                    })
                }
            })
        },
        function(token, user, done) {
            console.log(`https://${req.headers.host}/reset/${token}`)
            let resetUrl = `https://${req.headers.host}/reset/${token}`,
                email    = user.email,
                userName = user.username;
            ejs.renderFile(resetTemplate,{resetUrl,email,userName,logo,phone},'utf-8',function(err, data) {
                if(err){
                    if(req.xhr == true){ return res.status(400).send('Please try again password reset failed')}
                    req.flash('error', 'Please try again password reset failed'),
                    res.redirect('back');
                } else if(data){
                    var mailOptions = {
                        to: user.email,
                        from: 'admin@tradevity.com',
                        subject: 'Reset account password',
                        html: data
                    }
                    transporter_invos.sendMail(mailOptions, function(error, info) {
                        if (error) {
                            console.log('forgot error',error);
                            if(req.xhr == true){ return res.status(400).send('Try again')}
                            req.flash('error', 'Try again')
                            return res.redirect('back')
                        } else {
                            console.log(user.email + ' requested password reset');
                            if(req.xhr == true){ return res.send('A mail has been sent to ' + user.email + ' with further instructions')}
                            req.flash('success', 'A mail has been sent to ' + user.email + ' with further instructions')
                            req.session.save(function(){
                                return res.redirect('back')
                            })
                            
                        }
                    });
                }
            })
        }
    ])
}) 

// GET ROUTE FOR RESET PASSWORD

router.get('/reset/:token', function(req,res){
  User.findOne({ resetPasswordToken: req.params.token, resetPasswordExpires: { $gt: Date.now()}}, function(err, user){
      if(err){
          console.log(err);
          if(req.xhr == true){ return res.status(400).send('Password reset token is invalid or has expired')}
          req.flash('error', 'Password reset token is invalid or has expired')
          return res.redirect('/forgot')
      } else {
          res.render('reset', {token: req.params.token, page_name: 'reset'});
      }
  })
})

// RESET PASSWORD TOKEN POST AND EMAIL CONFIRMATION MESSAGE

router.post('/reset/:token', function(req, res, next) {
    asynco.waterfall([
        function(done) {
            User.findOne({resetPasswordToken :req.params.token, resetPasswordExpires: { $gt: Date.now()}}, function(err, user) {
                if(!user){
                  console.log(err);
                  if(req.xhr == true){return res.status(400).send('Password reset token is invalid or has expired')}
                  req.flash('error', 'Password reset token is invalid or has expired')
                  return res.redirect('back')
                };
                if(req.body.password === req.body.confirm) {
                    user.setPassword(req.body.password, function(err,user){
                        if(err){
                            console.log(err)
                            req.flash('error', 'Sorry something went wrong')
                            res.redirect('back')
                        } else {
                            user.resetPasswordToken = undefined
                            user.resetPasswordExpires = undefined
                            user.save(function(err){
                                console.log(err)
                                req.login(user, function(err){
                                    done(err,user)
                                })
                            })
                        }
                    })
                } else {
                    if(req.xhr == true){return res.status(400).send('Passwords do not match')}
                    req.flash('error', 'Passwords do not match')
                    return res.redirect('back');
                }
            })
        },
        function(user, done) {
            ejs.renderFile(changeTemplate,{logo,phone,dashboard,email:user.email,secure},'utf-8',function(err, data){
                if(err){
                    console.log(err);
                    if(req.xhr == true){return res.status(400).send('Password was unauthorized, please try again')}
                    req.flash('error', 'Password was unauthorized, please try again');
                    return res.redirect('back')
                } else if(data){
                    var mailOptions = {
                        to: user.email,
                        from: 'admin@tradevity.com',
                        subject: 'Account Password Changed',
                        html: data
                    };
                    transporter_invos.sendMail(mailOptions, function(err, passSent){
                        if(err){
                            console.log(err)
                            if(req.xhr == true){return res.status(400).send('Password was unauthorized, please try again')}
                            req.flash('error', 'Password was unauthorized, please try again');
                            return res.redirect('back')
                        } else {
                            if(req.xhr == true){return res.send('Success! your password has just been changed ' + user.username + ' welcome back')}
                            req.flash('success', 'Success! your password has just been changed ' + user.username + ' welcome back')
                            res.redirect('/dashboard')
                        }
                    })
                }
            })
        }
    ])
})

//  =============================== EMAIL VERIFICATION GOES HERE ===================

router.get("/verification", isLoggedIn, function(req,res,next){
   var link  = '/verification/';
   
   if(req.user.active === "true"){
       if(req.xhr == true){ return res.status(400).send(`Request denied: Your account has been verified before!`)}
       req.flash('error', 'Request denied: Your account has been verified before!');
       res.redirect('/login')
   } else if(req.user.active === "false"){
   asynco.waterfall([
        function(done) {
            crypto.randomBytes(20, function(err, buf){
                var token = buf.toString('hex');
                done(err, token);
            })
        },
        function(token, done) {
            User.findOne({ email: req.user.email }, function(err, user){
                if(!user){
                    if(req.xhr == true){ return res.status(400).send(`There is no user with that email address`)}
                    req.flash('error', 'There is no user with that email address');
                    return res.redirect('/forgot');
                } else {
                    user.verificationToken = token;
                    user.resetPasswordExpires = Date.now() + 3600000;
                    user.save(function(err){
                        done(err, token, user)
                    })
                }
            })
        },
        function(token, user, done) {
            let verify = 'https://' + req.headers.host + '/verify/' + token + '\n\n',
                email = user.email;
            ejs.renderFile(verifyTemplate,{verify,email,logo,phone},'utf-8', function(err,data){
                if(err){
                    console.log(err);
                    if(req.xhr == true){ return res.status(400).send(`Request Denied: Try again something went wrong`)}
                    req.flash('error', 'Request Denied: Try again something went wrong')
                    res.redirect('/login')
                } else if(data){
                    var mailOptions = {
                        to: email,
                        from: 'admin@tradevity.com',
                        subject: 'Tradevity Email verification',
                        html: data
                    };
                    transporter_invos.sendMail(mailOptions, function(err, sent){
                        if(err){
                            console.log(err)
                            if(req.xhr == true){ return res.status(400).send(`Request Denied: account verification could not be completed`)}
                            req.flash('error', 'Request Denied: account verification could not be completed')
                            res.redirect('/login')
                        } else {
                            console.log(user.email + ' sent verification');
                            if(req.xhr == true){ return res.send(`A mail with a verification link has been sent to ${user.email} with further instructions. <a href="${link}"> Click here to resend the link</a>.`)}
                            req.flash('success', 'A mail verification link has been sent to ' + user.email + ' with further instructions, <a href="'+link+'"> Click here to resend the link</a>.')
                            return res.redirect('/login')
                        }
                        
                    });
                }
            })
                
        }
    ])
   }
})


router.get('/verify-email/:id', function(req,res){
    
    User.findOne({_id: req.params.id}, function(err,found){
        if(err){
            console.log(err)
            req.flash('error', 'Request Denied: account verification could not be completed')
            res.redirect('/login')
        } else if(found != null){
            let link = `/verify/${found._id}`
            console.log(found.email);
            asynco.waterfall([
                function(done) {
                    crypto.randomBytes(20, function(err, buf){
                        var token = buf.toString('hex');
                        done(err, token);
                    })
                },
                function(token, done) {
                    found.verificationToken = token;
                    found.resetPasswordExpires = Date.now() + 3600000;
                    found.save(function(err){
                        done(err, token, found)
                    })
                },
                function(token, user, done) {
                    let verify = 'https://' + req.headers.host + '/verify/' + token + '\n\n',
                        email = user.email;
                    ejs.renderFile(verifyTemplate,{verify,email,logo,phone},'utf-8', function(err,data){
                        if(err){
                            console.log(err);
                            if(req.xhr == true){ return res.status(400).send(`Request Denied: Try again something went wrong`)}
                            req.flash('error', 'Request Denied: Try again something went wrong')
                            res.redirect('/login')
                        } else if(data){
                            var mailOptions = {
                                to: email,
                                from: 'admin@tradevity.com',
                                subject: 'Tradevity Email verification',
                                html: data
                            };
                            transporter_invos.sendMail(mailOptions, function(err, sent){
                                if(err){
                                    console.log(err)
                                    if(req.xhr == true){ return res.status(400).send(`Request Denied: account verification could not be completed`)}
                                    req.flash('error', 'Request Denied: account verification could not be completed')
                                    res.redirect('/login')
                                } else {
                                    console.log(user.email + ' sent verification');
                                    if(req.xhr == true){ return res.send(`A mail with a verification link has been sent to ${user.email} with further instructions. <a href="${link}"> Click here to resend the link</a>.`)}
                                    req.flash('success', 'A mail verification link has been sent to ' + user.email + ' with further instructions, <a href="'+link+'"> Click here to resend the link</a>.')
                                    return res.redirect('/login')
                                }
                                
                            });
                        }
                    })
                        
                }
            ])
        } else {
            res.send("No user with that id, please login into your account an request for a verification link")
        }
    })
})


// GET ROUTE FOR EMAIL VERIFICATION 


router.get('/verify/:token', function(req,res){
  var link  = '/verification/';
  User.findOne({ verificationToken: req.params.token, resetPasswordExpires: { $gt: Date.now()}}, function(err, user){
    //   console.log(user);
      if(err){
          console.log(err);
          if(req.xhr == true){ return res.status(400).send('Mail verify token is invalid or has expired, <a href="'+ link +'"> click here to resend the link </a>')}
          req.flash('error', 'Mail verification token is invalid or has expired, <a href="'+ link +'"> click here to resend the link </a>')
          return res.redirect('/forgot')
      } else if(user) {
        //   console.log(user.active)
          if(user.active === "true"){
              if(req.xhr == true){ return res.status(400).send(`Your account has been verified before`)}
              req.flash('success', 'Your account has already been verified');
              return res.redirect('/login')
          } else {
              console.log(user.active)
              user.active = "true"
              user.save( function(err, athourized){
                  if(err){
                      console.log(err)
                      if(req.xhr == true){ return res.status(400).send('Your account could not be verified')}
                      req.flash('error', 'Your account could not be verified')
                      res.redirect('/login')
                  } else {
                      ejs.renderFile(welcomeTemplate,{logo,phone,swift,rocket,investment,email: user.email},'utf-8',function(err,data){
                            if(err){
                                console.log(err)
                                res.redirect('back')
                            } else if(data) {
                                var mailOptions = {
                                    from: "admin@tradevity.com",
                                    to: user.email,
                                    subject: "Welcome on board",
                                    html: data
                                };
                                transporter_invos.sendMail(mailOptions, function(error, info) {
                                    if (error) {
                                        return console.log('verify error',error);
                                    } else {
                                        console.log("Email sent: " + info.response);
                                        if(req.xhr == true){
                                            console.log('done')
                                        } else {
                                            console.log(user.active);
                                            if(req.xhr == true){ return res.send('Your mail has been verified successfully, welcome to Tradevity')}
                                            req.flash('success', 'Your mail has been verified successfully, welcome to Tradevity');
                                            return res.redirect('/login');
                                        }
                                    }
                                });
                            }
                      })
                  }
              })   
          }
      } else if(user == null) {
          if(req.xhr == true){ return res.status(400).send(`User can't be found please try again later. or request for a new verification link`)}
          req.flash('error', `User can't be found please try again later. or request for a new verification link`);
          return res.redirect('/login')
      }
  })
})






// =============================================== EMAIL INVITATION MESSAGE ======================

// var transporter = nodemailer.createTransport({
//     service: 'gmail',
//     secure: true,
//     auth: {
//         user: '',
//         pass: process.env.PASS
//     }
// });

function isLoggedIn(req, res, next){
    if(req.isAuthenticated()){
        return next();
    } else if(req.xhr === true){
        res.status(400).send("You are currently unauthorized for this request")
    } else {
        req.flash("error", "Please login first to do that")
        res.redirect('/login');
    }
}

var logNotific = function(os,osVer,browser,ip,location,email){
    // console.log(os,osVer,browser,ip,location.country,email)
    let country = location.country;
    let secure = 'https://www.tradevity.com/forgot'
    let time = moment().format("YYYY-MM-DD HH:mm a", Date.now())
    ejs.renderFile(loginTemplate,{os,osVer,browser,ip,country,email,time,logo,phone,secure},'utf-8',function(err,data){
        if(err){
            console.log(err)
        } else if(data) {
            var mailOptions = {
                from: "admin@tradevity.com",
                to: email,
                subject: "Login Notification",
                html: data
            };
            transporter_invos.sendMail(mailOptions, function(error, info) {
                if (error) {
                    return console.log('error from sending email',error);
                } else {
                    console.log("Email sent: " + info.response);
                }
            });
        }
    })
}

let signedUp = function(req){
    console.log('reached here')
    var mailOptions = {
        from: "admin@tradevity.com",
        to: 'tradeutil@proton.me',
        subject: "New Signup",
        html: `
            <ul>
                <li> ${req.username} </li>
                <li> ${req.country} </li>
                <li> ${req.email} </li>
                <li> ${req.phone} </li>
            </ul>
        `
    };
    transporter_invos.sendMail(mailOptions, function(error, info) {
        if (error) {
            return console.log('error from sending email',error);
        } else {
            console.log("Email sent: " + info.response);
        }
    });
}

let refIncrement = function(found,user){

    let time = moment().format("YYYY-MM-DD HH:mm a", Date.now())
    ejs.renderFile(referralTemplate,{found,user,time,logo,phone,secure},'utf-8',function(err,data){
        if(err){
            console.log(err)
        } else if(data) {
            var mailOptions = {
                from: "admin@tradevity.com",
                to: found.email,
                subject: "Referral Signup",
                html: data
            };
            transporter_invos.sendMail(mailOptions, function(error, info) {
                if (error) {
                    return console.log('error from sending email',error);
                } else {
                    console.log("Email sent: " + info.response);
                }
            });
        }
    })
    
}

module.exports = {
    router,
    logNotific,
    withdrawRequest,
    endInvestment,
    reinvestment,
    saudi,
    signedUp,
    paymentComplete,
    paymentFailed,
    refIncrement,
    referralComplete,
    referralFailed,
    nfppayment,
    nfploan,
    surveydone
}

