var express     = require('express'),
    cookieParser= require('cookie-parser'),
    cooked      = require('cookie'),
    User        = require('../models/user'),
    normal      = require('../models/normal'),
    history     = require('../models/history'),
    aitrading   = require('../models/aihistory'),
    withHistory = require('../models/with-Histo'),
    cryptoRand  = require('crypto-random-string'),
    country     = require('geoip-lite'),
    sniffr      = require('sniffr')
var router      = express.Router();

router.use(cookieParser());

let s = new sniffr()

// normal.create({})

router.get("/", function(req,res){
    
    let cont = '1000';
    // const userAgent = req.headers['user-agent'];
    // let sinfo = s.sniff(userAgent);

    // var ip = req.headers['x-forwarded-for'];
    // var location = country.lookup(ip);
    // if(location.country == 'SA'){
    //     cont = '3,000'
    // } else {
    //     cont = '1000'
    // }
    
    normal.findOne({purpose: 'updating'}, function(err,found){
        if(!err){
            return res.render("home", {page_name: 'home', status: found, cont});
        } else {
            console.log(err)
        }
    })
})


router.get('/transaction-explor-cert-jin', function(req, res) {
    res.render('transact', {page_name: 'transactions', id: {stat: 'normal'}, transaction: {stat: 'normal'}})
})

router.get('/tiers', function(req, res) {
    res.render('tiers', {page_name: 'tiers'})
})

router.get('/client/survey', function(req, res) {
    res.render('survey', {page_name: 'survey'})
})

router.get('/black-friday-contracts', function(req, res) {
    res.render('black', {page_name: 'black-friday'})
})

router.get('/nfp-trading', function(req, res) {
    res.render('nfp', {page_name: 'non-farm'})
})

router.get('/crypto-price', function(req, res) {
    res.render('price', {page_name: 'crypto-price'})
})

router.get('/green-energy', function(req, res) {
    res.render('green', {page_name: 'green'})
})

router.post('/transaction-explorer', function(req, res) {
    let id = String(req.body.tranId);
    history.findOne({transId: req.body.tranId}, function(err, found) {
        if(err){
            console.log('err')
        } else if(found){
            return res.render('transact', {page_name: 'transactions', transaction: {stat: 'found', trans: found}, id: {stat: 'found'}})
        } else {
            aitrading.findOne({transId: id}, function(err, found) {
                if(err)console.log(err)
                else if(found){
                   return res.render('transact', {page_name: 'transactions', transaction: {stat: 'found', trans: found}, id: {stat: 'found'}})
                } else{
                    withHistory.findOne({transId: id}, (err,found)=>{
                        if(err)console.log(err)
                        else if(found){
                            return res.render('transact', {page_name: 'transactions', transaction: {stat: 'found', trans: found}, id: {stat: 'found'}})
                        } else {
                            return res.render('transact', {page_name: 'transactions', transaction: {stat: 'normal'}, id: {stat: 'none', idname: req.body.tranId}})
                        }
                    })
                    
                }
            })
        }
    })
})

// router.get('/inviteJoin/:id', (req,res) =>{
//     console.log(req.cookies.compRef);
//     var refKing = req.params.id;
//     let cookieOptions = {
//         maxAge: 2629800,
//         httpOnly: false
//     }
    
//     // res.setHeader('Set-Cookie', cooked.serialize('name', String("cool"), {
//     //   httpOnly: true,
//     //   secure: true,
//     //   maxAge: 60 * 60 * 24 * 7 // 1 week
//     // }));

//     res.cookie('compRef',refKing,{httpOnly: false, secure: true,maxAge: 2629800})
//     console.log(req.cookies);
//     return res.redirect('/');
// })

router.get('/inviteJoin/:id', (req,res) =>{
    console.log(req.cookies.compRef);
    var refKing = req.params.id;
    let cookieOptions = {
        maxAge: 2629800,
        httpOnly: false
    }
    
    res.cookie('compRef',refKing,{httpOnly: false, secure: true,maxAge: 2629800})
    console.log(req.cookies);
    return res.redirect('/');
})

router.get("/about", function(req,res){
    res.render("about", {page_name: 'about'})
})

router.get("/referral-program", function(req,res){
    
    normal.findOne({purpose: 'updating'}, function(err,found){
        if(!err){
            res.render("affiliate", {page_name: 'referral-program', status: found})
        } else {
            console.log(err)
        }
    })
})

// router.get("/blog", function(req, res) {
//     res.render("coming", {page_name: 'coming'})
// })

router.get('/invite/:id', (req,res) =>{
var refKing = req.params.id;
    let cookieOptions = {
        maxAge: 1000 * 60 * 60,
        httpOnly: true,
        secure: true
    }
    res.cookie('ref',refKing,cookieOptions)
    return res.redirect('/');
})

// router.get('/trading', (req,res)=>{
//     res.render('trading', {page_name: 'trade'})
// })

router.get("/contact", function(req,res){
    // req.flash('success', 'hello there')
    res.render("contact", {page_name: 'contact'})
})

router.get("/login", function(req,res){
    res.render("login", {page_name: 'login'})
})

router.get("/mining", function(req,res){
    res.render("mining", {page_name: 'mining'});
})

router.get("/forgot", function(req,res){
    res.render("forgot", {page_name: 'forgot'})
})

router.get("/faq", function(req,res){
    res.render("faq", {page_name: 'faq'})
})

router.get("/bug-bounty", function(req,res){
    res.render("bug", {page_name: 'bounty'})
})

router.get("/gold-etf", function(req,res){
    res.render("gold", {page_name: 'gold-etf'})
})

router.get("/legal/terms", function(req,res){
    res.render("legal/terms", {page_name: 'terms'})
})

router.get("/ai-bot", function(req,res){
    res.render("ai", {page_name: 'ai-bot'})
})

router.get("/uphistory", function(req,res){
    res.render('uphistory')
})

router.get("/real-estate", (req,res)=>{
    res.render('realestate', {page_name: 'real estate'});
})

router.post("/tempup/inter", function(req,res){
    let data = req.body;
    if(data.pw == "waka#$"){
        let specid = cryptoRand(24).toString('hex').toUpperCase()
        console.log(specid)
            
        history.create({
            amount: data.amount,
            method: data.method,
            coinAmount: data.coinAmount,
            transId: specid
            
            
        }, function(err, created){
            if(err){
                console.log(err);
            } else {
                created.owner.id = data.userid;
                created.owner.username = data.username;
                created.save();
                res.send("Created successfully")
            }
        })
    } else {
        res.send(`You can't procced`)
    }
})

// router.get("/reset", function(req,res){
//     res.render("reset", {page_name: 'reset', token: '1234'})
// })

router.get("/register", function(req,res){
    
    if(req.cookies.compRef){
        let usernamen = req.cookies.compRef
        console.log(usernamen)
        User.findOne({username: usernamen}, function(err,result){
           if (err){
               console.log(err)
               res.render("register", {page_name: 'register', ID: 'none'})
           } else if (result){
               console.log(result._id)
               res.render("register", {page_name: 'register', ID: result._id})
           } else if(!result){
               res.render("register", {page_name: 'register', ID: 'none'})
           }
        })
    } else {
        res.render("register", {page_name: 'register', ID: 'none'})
    }
})

// ====================== LOGOUT LOGICS ============

router.get("/logout", function(req, res) {
    if(!req.isAuthenticated()){
        req.flash('error', 'You are not logged in either');
        res.redirect('/login')
    } else {
        req.logout(function(err){
            if(err){
                req.flash('error', `can't log you out, try again`)
                res.redirect('/login')
            }
        });
        if(req.session.secondFactor){
            delete req.session.secondFactor;
        }
        req.flash("success", "Logged you out successfully")
        return res.redirect("/login")
    }
})

// ================================= MIDDLE WARE ==============

function isLoggedIn(req, res, next){
    if(req.isAuthenticated()){
        return next();
    }
    req.flash("error", "Please login first to do that")
    res.redirect('/login');
}

module.exports = router