var router              = require('express').Router()
var moment              = require('moment'),
    User                = require('../models/user'),
    History             = require("../models/history"),
    withistory          = require("../models/with-Histo.js"),
    trade               = require("../models/trading")


router.get("/dashboard/:id/history", isLoggedIn, isVerified, function(req,res){
    User.findById(req.params.id, function(error,found){
        if(error){
            console.log(error);
        } else {
            History.find({}).where('owner.id').equals(req.user._id).exec(function(err,found){
                if(err){
                    console.log(err);
                } else {
                    // console.log(found)
                    trade.find({}).where('owner.id').equals(req.user._id).exec(function(err,trade){
                        if(err){
                            console.log(err);
                        } else {
                            var time = moment().format('LTS',found.date);
                            
                            withistory.find({}).where('owner.id').equals(req.user._id).exec(function(err,withisto){
                                if(err) return console.log(err)
                                return res.render("dash-web/history", {history: found, Time: time, trade,withisto})
                            })
                        }
                    })
                    
                }
                
            })
            
        }
    })
    
})

// router.get('/products/:page', function(req, res, next) {
//     var perPage = 9
//     var page = req.params.page || 1

//     withistory
//         .find({})
//         .skip((perPage * page) - perPage)
//         .limit(perPage)
//         .exec(function(err, products) {
//             if(err) throw err
//             else {
//                 withistory.count().exec(function(err, count) {
//                     if (err) return next(err)
//                     res.send('his.ejs', {
//                         products: products,
//                         current: page,
//                         pages: Math.ceil(count / perPage)
//                     })
//                 })
//             }
//         })
// })

// ================================= MIDDLE WARE ==============
function isVerified(req,res,next){
    var link = '/verification/' 
    if(req.user.active === "true"){
        return next()
    } else {
        req.flash('error', 'Request unauthorized:' +  ' your mail link is yet to be verified, <a href="'+ link +'"> Click here to resend the link</a>.')
        res.redirect('/login')
    }
}

function isLoggedIn(req, res, next){
    if(req.isAuthenticated()){
        return next();
    }
    req.flash("error", "Please login first to do that")
    res.redirect('/login');
}

module.exports = router