var express     = require('express'),
    router      = express.Router(),
    nodemailer  = require('nodemailer'),
    User        = require('../models/user'),
    affiliate   = require("../models/affiliate"),
    crypto      = require('crypto'),
    history     = require("../models/history");
    
const { verify }           = require(`coinpayments-ipn`);
const CoinpaymentsIPNError = require(`coinpayments-ipn/lib/error`);
let { paymentFailed }      = require('../routes/mail');
let { paymentComplete }    = require('../routes/mail');
let { nfppayment }         = require('../routes/mail')

let key = {
    MERCHANT_ID: process.env.MERCHANT_ID,
    IPN_SECRET:  process.env.IPN_SECRET,
}

let nowKey = process.env.nowKeyo

let check = {id: "CPEC5PJVJ6JI3OVM7EUZEQ6YU7"}

// history.find({transId: check.id }, function(err,found){
//     if(err){
//         console.log(err)
//     } else {
//         console.log(found[0]);
//     }
// })

let percentage = '';

// router.post('/payment', function(req,res){
//     console.log("request came into PAYMENT")
//     // console.log("X" + req.x-nowpayments-sig);
//     console.log("BODY" + req.body)
//     const hmac = crypto.createHmac('sha512', "");
//     hmac.update(JSON.stringify(req.body, Object.keys(req.body).sort()));
//     const signature = hmac.digest('hex');
//     console.log("SIGNATURE" + signature);
    
// })

router.post('/ipnnotify', function (req, res, next) {
    
  
  console.log("request came into PAYMENT")

    console.log( req.headers['x-nowpayments-sig'])
    console.log(req.body)
    const hmac = crypto.createHmac('sha512', nowKey);
    hmac.update(JSON.stringify(req.body, Object.keys(req.body).sort()));
    const signature = hmac.digest('hex');
    console.log("SIGNATURE" + signature);
    
    let isValid = signature, error = "not same x signature"
    
    if(isValid == req.headers['x-nowpayments-sig']){
        console.log(req.body.price_amount)
    } else {
        return next(error)
    }
    

  return next();
}, function (req, res, next) {
    console.log(req.body.order_description, req.body)
    console.log(`Process payment notification`);
    if(req.body.payment_status == 'waiting'){
        console.log('transaction still pending');
    } else if(req.body.payment_status == 'expired'){
        console.log('transaction cancelled');
        let data = req.body;
        history.find({"transId": data.payment_id}, function(err,found){
            if(!found){
                console.log('user not found for payment status attachment')
            }
            if(found[0].checked == true){
                return console.log('user already checked')
            } else if(found[0].checked == false){
                if(err){
                    console.log(err);
                } else if(found){
                    found = found[0]
                    found.statusLevel = 'Cancelled'
                    found.checked = true
                    found.save(function(err,saved){
                        if(err)console.log(err)
                        if(saved){
                            console.log(saved.statusLevel);
                            User.findById(saved.owner.id, function(err,user){
                                if(err){
                                    console.log(err);
                                } else if(user){
                                    // Email follows up here;
                                    paymentFailed(data,user.username);
                                } else {
                                    return console.log(`user not found`)
                                }
                            })
                        }
                    })
                }
            }
        })
        
        
    } else if(req.body.payment_status == 'finished'){
        console.log('transaction completed')
        let data = req.body;
        history.find({transId: data.payment_id}, function(err,found){
            if(err){
                console.log(err);
            } else if(found){
                if(found[0].checked == true){
                    return console.log(`user already checked`)
                } else if(found[0].checked == false){
                    found = found[0]
                    found.statusLevel = 'Completed'
                    found.checked = true
                    found.save(function(err,saved){
                        if(err) {
                            return console.log(err)
                        }
                        if(saved){
                            console.log(saved.statusLevel);
                            let convert = parseInt(saved.amount,10)
                            if(req.body.order_description == 'nfp'){
                                
                                console.log('confirmed transaction on NFP')
                                User.findOne({_id: found.owner.id}, (err,saveduser)=>{
                                    if(err){
                                        console.log(err)
                                    } else if(saveduser){
                                        return nfppayment(saveduser,saved);
                                    }
                                })
                            } else {
                                User.findOneAndUpdate({_id: found.owner.id}, {$inc: {deposit: convert}, $set: {investment: 'active'}},{new: true}, function(err,updated){
                                    if(err) return console.log(err)
                                    if(updated){
                                        console.log(updated.investment, updated.deposit)
                                        // Email follows up here;
                                        if(updated.deposit > 9999 && updated.deposit < 20000){
                                            updated.plan = 'economy'
                                            return updated.save(function(err,saveduser){
                                                if(err){
                                                    console.log(err)
                                                } else if(saveduser){
                                                    percentageReturn(saveduser.plan, found.duration);
                                                    return paymentComplete(data,saveduser,found.duration,percentage);
                                                }
                                            })
                                        } else if(updated.deposit > 19999 && updated.deposit < 50000){
                                            updated.plan = 'business'
                                            return updated.save(function(err,saveduser){
                                                if(err){
                                                    console.log(err)
                                                } else if(saveduser){
                                                    percentageReturn(saveduser.plan, found.duration);
                                                    return paymentComplete(data,saveduser,found.duration,percentage);
                                                }
                                            })
                                        } else if(updated.deposit > 49999 && updated.deposit < 100000){
                                            updated.plan = 'first-class'
                                            return updated.save(function(err,saveduser){
                                                if(err){
                                                    console.log(err)
                                                } else if(saveduser){
                                                    percentageReturn(saveduser.plan, found.duration);
                                                    return paymentComplete(data,saveduser,found.duration,percentage);
                                                }
                                            })
                                        } else if(updated.deposit > 99999){
                                            updated.plan = 'executive'
                                            return updated.save(function(err,saveduser){
                                                if(err){
                                                    console.log(err)
                                                } else if(saveduser){
                                                    percentageReturn(saveduser.plan, found.duration);
                                                    return paymentComplete(data,saveduser,found.duration,percentage);
                                                }
                                            })
                                        } else {
                                            console.log(found.duration)
                                            percentageReturn(updated.plan,found.duration);
                                            return paymentComplete(data,updated,found.duration,percentage);   
                                        }
                                        
                                    } else console.log('something is wrong with updating users deposit')
                                })
                            }
                            // here
                        }
                    })
                }
            }
        })
    }
    // completedTrans(req.body,req.body.txn_id);
  return next();
});


function percentageReturn(plan,duration){
    
    if(plan == "starter"){
        return percentage = '14'
    }
    if(plan == "basic"){
        return percentage = '16'
    }
    if(plan == "deluxe"){
        return percentage = '18'
    }
    if(plan == "enterprize"){
        return percentage = '19.6'
    }
    if(plan == "premium"){
        return percentage = '20.8'
    }
    // if(plan == 'starter' && duration == '1'){
    //     return percentage = '4';
    // }
    // if(plan == 'starter' && duration == '3'){
    //     return percentage = '2.5';
    // }
    // if(plan == 'deluxe' && duration == '1'){
    //     return percentage = '5';
    // }
    // if(plan == 'deluxe' && duration == '3'){
    //     return percentage = '3';
    // }
    // if(plan == 'deluxe' && duration == '6'){
    //     return percentage = '1.75';
    // }
    // if(plan == 'enterprize' && duration == '1'){
    //     return percentage = '7';
    // }
    // if(plan == 'enterprize' && duration == '3'){
    //     return percentage = '4';
    // }
    // if(plan == 'enterprize' && duration == '6'){
    //     return percentage = '2.50';
    // }
    // if(plan == 'enterprize' && duration == '12'){
    //     return percentage = '1.5';
    // }
    // if(plan == 'premium' && duration == '1'){
    //     return percentage = '8';
    // }
    // if(plan == 'premium' && duration == '3'){
    //     return percentage = '5';
    // }
    // if(plan == 'premium' && duration == '6'){
    //     return percentage = '3.5';
    // }
    // if(plan == 'premium' && duration == '12'){
    //     return percentage = '1.25';
    // }
    // else{
    //     console.log(`nothing to add to percentage`)
    // }
}

// var middleware = [
//   coinPayment.ipn({
//     'merchantId': "a47d73ac6cf67364330b4273610d5a0f",
//     'merchantSecret': "hellothere12EDFG"
//   }), 
//   function (req, res, next) {
//     // Handle via middleware
//     var data = req.body
//     console.log(data);
//     console.log('handling working');
//     if(req.body.status == 1 && req.body.ipn_type === 'api'){
//         history.find({transId: data.txn_id}, function (err, investor) {
//             if(err){
//                 console.log(err)
//             } else {
//                 investor.statusLevel = 'Completed'
//                 investor.save(function(err, success){
//                     if(err){
//                         console.log(err);
//                     } else {
//                         console.log(success)
//                     }
//                 })
//                 var convert = parseInt(data.amount1,10)
//                 User.findByIdAndUpdate(investor.owner.id, {$inc: {deposit: convert}}, {new: true}, function(err,found){
//                     if(err){
//                         console.log(err)
//                     } else {
//                         found.save();
//                     }
//                 })
//                 completedTrans(data.amount1,data.amount2,data.buyer_email,data.status,data.txn_id);
//             }
//         })
//     }
// }]

// router.use('/ipnnotify',middleware);

// let events = coinPayment.events;

// events.on('ipn_fail', function(data){
//     console.log("IPN FAIL");
//     console.log('inval', data);
//     history.findOne({transId: data.txn_id}, function (err, investor) {
//         if(investor.length < 1 || err){
//             console.log(err)
//         } else {
//             investor.statusLevel = 'Cancelled'
//             investor.save(function(err, success){
//                 if(err){
//                     console.log(err);
//                 } else {
//                     console.log(success)
//                 }
//             })
//             console.log("found investor",investor)
//             User.findById({_id: investor.owner.id}, function(err,found){
//                 if(err){
//                     console.log(err)
//                 } else {
//                     console.log("found user",found)
//                 }
//             })
//         }
//     })
// });

// events.on('ipn_pending', (data)=>{
//     console.log('coin pending')
//     console.log('inalid', data)
//     history.findOne({transId: data.txn_id}, function (err, investor) {
//         if(err){
//             console.log(err)
//         } else {
//             investor.statusLevel = 'Pending.'
//             investor.save(function(err, success){
//                 if(err){
//                     console.log(err);
//                 } else {
//                     console.log(success)
//                 }
//             })
//             console.log("found investor",investor)
//             User.findOne({_id: investor.owner.id}, function(err,found){
//                 if(err){
//                     console.log(err)
//                 } else {
//                     console.log("found user",found)
//                 }
//             })
//         }
//     })
// })

function completedTrans(data,transId){
    let smtpTransport = nodemailer.createTransport({
        host: 'moya.black.host',
        port: 465,
        secure: true,
        auth: {
            user: 'support@tradeworth.org', 
            pass: process.env.SUPPORT
        }
    });
    
    var mailOptions = {
        to: 'tradeworth@protonmail.com',
        from: 'account@tradeworth.org',
        subject: 'completed transaction on wash',
        html: `
            <h1>Completed Transactions</h1>
            <ul>
                <li>Amount in usd paid: ${data}</li>
                <li>Amount in usd paid: ${transId}</li>
            </ul>
        `
    };
    smtpTransport.sendMail(mailOptions, function(err, sent){
        if(err){
            console.log(err)
        } else {
            console.log('Request of transaction completion sent successfully');
        }
    });
}

module.exports = router;