var express             = require('express'),
    router              = express.Router(),
    passport            = require('passport'),
    asynco              = require("async"),
    normal              = require('../models/normal'),
    User                = require('../models/user'),
    Coinpayments        = require("coinpayments"),
    History             = require("../models/history"),
    withistory          = require("../models/with-Histo.js"),
    trade               = require("../models/trading"),
    nodemailer          = require("nodemailer"),
    request             = require('request'),
    country             = require('geoip-lite'),
    sniffr              = require('sniffr'),
    moment              = require('moment'),
    nowpayments         = require("@nowpaymentsio/nowpayments-api-js")

let { surveydone }         = require('../routes/mail')
    
let s = new sniffr()
    
let  {endInvestment}        = require('./mail');
let  {reinvestment}         = require('./mail');
let  {createAffiliateTrans} = require('./affiliate')

let nowkid = process.env.nowapi

let api = new nowpayments({apiKey: nowkid})

// User.updateMany({},

// {$set: {available: 0}},

// function(err,resu){
//     if(err){
//         console.log(err)
//     } else {
//         console.log(resu)
//     }
// })

// ======================================= Dashboard pages ====================

// router.get('/when', (req,res)=>{
//     normal.create({}, function(err,tin){
//         if(err)console.log(err)
//         console.log(tin)
//     })
// })

router.get('/dashboard', isLoggedIn, isVerified, function(req,res){
    normal.findOne({purpose: 'updating'}, function(err,found){
        if(!err){
            return res.render("dash-web/dashboard", {status: found})
        } else {
            console.log(err)
            res.redirect('/login')
        }
    })
})

// router.get('/updateme', (req,res)=>{
//     User.update({}, {
//         cryptoaddress: '',
//         currency: '',
//         botaddress: '',
//         paymethod: 'manual'
        
//     }, {multi: true}, function(err, numaffected, raw){
//         if(err){
//             console.log(err)
//         } else {
//             console.log(numaffected, raw)
//             res.send('hello there processed');
//         }
//     })
// })

router.get("/dashboard/:id/view", isLoggedIn, isVerified, function(req,res){
    User.findById(req.params.id, function(error,found){
        // console.log(req.params.id);
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard")
        } else {
            normal.findOne({purpose: 'updating'}, function(err,found){
                if(!err){
                    return res.render("dash-web/viewed", {status: found})
                } else {
                    console.log(err)
                    res.redirect('/login')
                }
            })
        }
    })
})

// ============================================ EDIT ROUTE PROFILE ==================

router.get("/dashboard/:id/edit", isLoggedIn, isVerified, function(req,res){
    User.findById(req.params.id, function(error, found){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard");
        } else {
            res.render("dash-web/edit")
        }
    })
})

router.put("/dashboard/:id/update", isLoggedIn, isVerified, function(req,res){
    console.log(req.body.update.email);
    if(
        req.body.update.email || req.body.email || req.body.update.profit || req.body.update.superUser
        ){
        return res.status(400).send('Error: Your form could not be submitted')
    } else {
        console.log('arriving')
        User.findOneAndUpdate({_id: req.params.id}, req.body.update, function(error, updated){
            if(error){
                console.log("error occured " + error);
                return res.status(400).send("Error: account couldn't be updated")
            } else {
                req.logIn(updated, function(err) {
                    if (err) {
                        console.log(err);
                        return res.status(400).send('Session: Your session has expired, please login again'); 
                    } else {
                        req.session.save(function(){
                            return  res.send('updated successful');
                        });
                    }
                });
            }
        })
    }
})


router.get("/dashboard/:id/deposit", isLoggedIn, isVerified, function(req,res){
    User.findById(req.params.id, function(error, found){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard");
        } else {
            res.render("dash-web/deposit")
        }
    })
})

router.get("/dashboard/:id/mining", isLoggedIn, isVerified,  function(req,res){
    User.findById(req.params.id, function(error, found){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard");
        } else {
            res.render("dash-web/mining")
        }
    })
})
    
// router.get("/dashboard/lock", function(req,res){
//     req.logout();
//     res.render("dash-web/lockScreen")
// }) 

router.post('/deactiveLogin',isLoggedIn, isVerified, function(req,res){
    let id = req.user._id;
    if(req.user.logEmail != 'active'){
        return res.status(400).send('This feature has already been deactivated');
    } else if(req.user.logEmail == 'active'){
        User.findOneAndUpdate({_id: id},{$set: {logEmail: 'inactive'}})
        .then(function(suc){
            return res.send('Email login notification deactivated successfully!')
        })
        .catch(function(err){
            return res.status(400).send('Try again, this service might be currently not be available')
        })
    }
})

router.post('/activateLogin', isLoggedIn, isVerified, function(req,res){
    let id = req.user._id;
    if(req.user.logEmail == 'active'){
        return res.status(400).send('This feature has already been activated');
    } else if(req.user.logEmail == 'inactive'){
        User.findOneAndUpdate({_id: id},{$set: {logEmail: 'active'}}, function(err,suc){
            if(err){
                return res.status(400).send('Try again, this service might currently not be available')
            } else {
                res.send('Email login notification activated!')
            }
        })
    }
})

router.post('/survey/done', isLoggedIn, isVerified, function(req,res){
    let data = req.body;
    // console.log(data)
    surveydone(data,res)
})

router.get("/dashboard/addInvestment", isLoggedIn, isVerified, function(req,res){
    let cont = '1000';
    const userAgent = req.headers['user-agent'];
    let sinfo = s.sniff(userAgent);

    var ip = req.headers['x-forwarded-for'];
    var location = country.lookup(ip);
    // if(location.country == 'SA'){
    //     cont = '3,000'
    // } else {
    //     cont = '1,000'
    // }
    res.render("dash-web/investment", {cont})
})

router.get("/dashboard/settings", isLoggedIn, isVerified, function(req,res){
    res.render("dash-web/settings")
})

router.get("/dashboard/paytest", isLoggedIn, isVerified, function(req,res){
    res.render("dash-web/paytest", {payInfo: {}})
})

// ======================================== PLAN SETTINGS USER SETTINGS  ==============================

router.get('/starter/:id', isLoggedIn, isVerified, function(req, res) {
    User.findByIdAndUpdate(req.params.id, {$set: {plan: 'starter'}}, function(error, updated){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard")
            } else {
                req.flash('success', 'Updated: You have migrated to the Starter plan ' + req.user.username)
                res.redirect("/dashboard/" + req.params.id + "/deposit")    
           }
    })
})

// router.get('/professional/:id', isLoggedIn, isVerified, function(req, res) {
    
//      User.findByIdAndUpdate(req.params.id, {$set: {plan: 'professional'}}, function(error, updated){
//         if(error){
//             console.log("error occured " + error);
//             return res.redirect("/dashboard")
//             } else {
//                 req.flash('success', 'Updated: You have migrated to the Professional plan ' + req.user.username)
//                 res.redirect("/dashboard/" + req.params.id + "/deposit")    
//           }
//     })
    
// })

router.get('/economy/:id', isLoggedIn, isVerified, function(req, res) {
    
    User.findByIdAndUpdate(req.params.id, {$set: {plan: 'economy'}}, function(error, updated){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard")
            } else {
                req.flash('success', 'Updated: You have migrated to the Economy plan ' + req.user.username)
                res.redirect("/dashboard/" + req.params.id + "/deposit")    
           }
    })
    
})

router.get('/business/:id', isLoggedIn, isVerified, function(req, res) {
     User.findByIdAndUpdate(req.params.id, {$set: {plan: 'business'}}, function(error, updated){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard")
            } else {
                req.flash('success', 'Updated: You have migrated to the Business plan ' + req.user.username)
                res.redirect("/dashboard/" + req.params.id + "/deposit")    
          }
    })
})

router.get('/firstclass/:id', isLoggedIn, isVerified, function(req, res) {
     User.findByIdAndUpdate(req.params.id, {$set: {plan: 'first-class'}}, function(error, updated){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard")
            } else {
                req.flash('success', 'Updated: You have migrated to the First-class plan ' + req.user.username)
                res.redirect("/dashboard/" + req.params.id + "/deposit")    
           }
    })
    
})

router.get('/executive/:id', isLoggedIn, isVerified, function(req, res) {
     User.findByIdAndUpdate(req.params.id, {$set: {plan: 'executive'}}, function(error, updated){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard")
            } else {
                req.flash('success', 'Updated: You have migrated to the Executive plan ' + req.user.username)
                res.redirect("/dashboard/" + req.params.id + "/deposit")    
           }
    })
    
})

// ============================================= BITCOIN STUFFS HERE =====================



var client = new Coinpayments({
    key: process.env.COINKEY || 'hellothere',
    secret: process.env.COINSECRET || 'youtoothere'
});


router.post('/bitcoin/:id', isLoggedIn, isVerified, function(req, res) {
    let coin = 'BTC';
    allTransactions(req,res,coin)
})

router.post('/tether/:id', isLoggedIn, isVerified, function(req, res) {
    let coin = 'USDTERC20';
    allTransactions(req,res,coin)
})

router.post('/tethertrx/:id', isLoggedIn, isVerified, function(req, res) {
    let coin = 'USDTTRC20';
    allTransactions(req,res,coin)
})

router.post('/ethereum/:id', isLoggedIn, isVerified, function(req, res) {
    let coin = 'ETH';
    allTransactions(req,res,coin)
})

router.post('/litecoin/:id', isLoggedIn, isVerified, function(req, res) {
    let coin = 'LTC';
    allTransactions(req,res,coin)
})

router.post('/dogecoin/:id', isLoggedIn, isVerified, function(req, res) {
    let coin = 'DOGE';
    allTransactions(req,res,coin)
})

router.post('/bitcash/:id', isLoggedIn, isVerified, function(req, res) {
    console.log('found bitcash')
    let coin = 'BCH';
    allTransactions(req,res,coin)
})


router.post('/nfp/deposit', isLoggedIn, isVerified, function(req,res){
    console.log(req.body.nfpamount)
    let coin = 'BTC'
    let amount = req.body.nfpamount
    transFunc(amount,req,res,coin,1,'nfp')
})

// function createdTransaction(amount,user,req) {
//     var smtpTransport = nodemailer.createTransport({
//         host: 'tron.black.host',
//         port: 465,
//         secure: true,
//         auth: {
//             user: 'accounts@bitthedge.com', 
//             pass: process.env.ACCOUNTS
//         }
//     });
//     var mailOptions = {
//         to: user.email,
//         from: 'transactions@bitthedge.com',
//         subject: 'Created Transaction',
//         html:   '<center><h1> CREATED TRANSACTION </h1></center>' + 
//                 '<br>' + '<br>' + '<p>Hello ' + user.username + '</p>' + '<br>' +
//                 '<p>This is a notification to confirm that you have just created a crypto transaction for this TradeWorth account <a style="color: red">'
//                 + user.email +'</a>  Do ensure to pay into the specified address, Please pay with the crypto amount provided by the payment processor, In the case of timeout status, check your mail for crypto refund link</p> ' + 
//                 '<br>' + ' Remember if you encounter any problem do not hesitate to contact us at support@six6options.com.. Waiting for confirmation of transaction created ' + 
//                 '<br>' + '<br>' + '<hr>' + '<br>' +
//                 `<div style="text-align: center"> Sent by <a href="${req.hostname}">Sixoptions</a> . <a> Pfingstweidstrasse 110, 8005 Zürich, Switzerland</a></div>`
              
//     };
//     smtpTransport.sendMail(mailOptions, function(err, sent){
//         if(err){
//             console.log(err)
//         } else {
            
//         }       
//     });
// }

// ========================    INCREMENT TRANSACTION CREATED =======
function pendingCounter(req,res){
    User.findByIdAndUpdate(req.params.id, {$inc: {pending:1}}, function(error, updated){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard")
            } else {
                    // console.log('total updated' + updated)
           }
    })
}

function tradingCounter(req,res){
    User.findByIdAndUpdate(req.params.id, {$inc: {miningPending: 1}}, function(error, updated){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard")
            } else {
                    
           }
    })
}


function transFunc(amount,req,res,coin,duration,purpose){
    
    async function logCurrencies(){
        let payment = await api.createPayment({price_amount: amount, price_currency: "usd", pay_currency: coin, ipn_callback_url: "https://www.tradevity.com/ipnnotify" ,
        order_description: purpose})
        let vab = payment.payment_id
        console.log(vab)
            console.log(payment)
            User.findOne({_id: req.params.id}, function(err,found){
                if(err){
                    console.log(err)
                } else {
                    
                    let data = {amount, transId: payment.payment_id}
                    if(found){
                        if(found.referral.referredby != 'none'){
                            createAffiliateTrans(found.referral.referredby,data); 
                        }
                    }
                    
                    History.create({
                        amount: amount,
                        duration: '3',
                        method: coin,
                        transId: payment.payment_id,
                        totalPaid: payment.pay_amount
                        
                    }, function(err, created){
                        if(err){
                            console.log(err);
                        } else {
                            created.owner.id = req.user._id;
                            created.owner.username = req.user.username;
                            created.save();
                            console.log("new created history" + created)
                        }
                    })
                }
                
            })
            
            // createdTransaction(amount, req.user);
            pendingCounter(req, res)
            var nowpaymentss = payment;
            return res.render('dash-web/payment', {payInfo: nowpaymentss})
    }
    logCurrencies()
    .catch(console.error)
    .then(() => console.log('We do cleanup here'));
}

function allTransactions(req,res,coin){
    var input = req.body.amount,
        duration = req.body.period,
        amount = parseInt(input,10);
    if(!input){
        req.flash('error', 'An amount is needed')
        return res.redirect('/dashboard/' + req.params.id + '/deposit')
    }
    
    if(req.user.investment === "active" && amount > 9){
        transFunc(amount,req,res,coin,duration,'crypto')
    } else if (req.user.plan === 'starter'){
        if(amount < 1000){
            req.flash('error', 'The amount ' + amount + ' dollar is less than your ' + req.user.plan + ' plan minimum deposit ' + req.user.username)
            res.redirect('/dashboard/' + req.params.id + '/deposit')
        } else if(amount > 9999){
            req.flash('error', 'The amount ' + amount + ' dollar is more than your ' + req.user.plan + ' plan maximum deposit ' + req.user.username)
            res.redirect('/dashboard/' + req.params.id + '/deposit')
        } else {
            console.log('starter')
            transFunc(amount,req,res,coin,duration,'crypto')
        }
       
    } else if (req.user.plan === 'economy') {
        
        if(amount < 10000){
            req.flash('error', 'The amount ' + amount + ' dollar is less than your ' + req.user.plan + ' plan minimum deposit ' + req.user.username)
            res.redirect('/dashboard/' + req.params.id + '/deposit')
        } else if(amount > 19999){
            req.flash('error', 'The amount ' + amount + ' dollar is more than your ' + req.user.plan + ' plan maximum deposit ' + req.user.username)
            res.redirect('/dashboard/' + req.params.id + '/deposit')
        } else {
            transFunc(amount,req,res,coin,duration,'crypto')
        }
        
    } else if(req.user.plan === 'business'){
        if(amount < 20000){
            req.flash('error', 'The amount ' + amount + ' dollar is less than your ' + req.user.plan + ' plan minimum deposit ' + req.user.username)
            res.redirect('/dashboard/' + req.params.id + '/deposit')
        } else if(amount > 49999){
            req.flash('error', 'The amount ' + amount + ' dollar is more than your ' + req.user.plan + ' plan maximum deposit ' + req.user.username)
            res.redirect('/dashboard/' + req.params.id + '/deposit')
        } else {
            transFunc(amount,req,res,coin,duration,'crypto')
        }
    } else if (req.user.plan === 'first-class'){
        if(amount < 50000){
            req.flash('error', 'The amount ' + amount + ' dollar is less than your ' + req.user.plan + ' plan minimum deposit ' + req.user.username)
            res.redirect('/dashboard/' + req.params.id + '/deposit')
        } else if(amount > 99999){
            req.flash('error', 'The amount ' + amount + ' dollar is more than your ' + req.user.plan + ' plan maximum deposit ' + req.user.username)
            res.redirect('/dashboard/' + req.params.id + '/deposit')
        } else {
            transFunc(amount,req,res,coin,duration,'crypto')
        }
    } else if (req.user.plan === 'executive'){ 
        if(amount < 100000){ 
            req.flash('error', 'The amount ' + amount + ' dollar is less than your ' + req.user.plan + ' plan minimum deposit ' + req.user.username)
            res.redirect('/dashboard/' + req.params.id + '/deposit')
        } else {
            transFunc(amount,req,res,coin,duration,'crypto')
        }
    } else if (req.user.investment === "active" && amount < 500){
        req.flash('error', 'The amount ' + amount + ' dollar is less than the minimum required top up amount. ($500) ')
        res.redirect('/dashboard/' + req.params.id + '/deposit')
    }
}

// ==================================== Mining Crypto ============
var mining = new Coinpayments({
    key: process.env.COINKEY || 'hellotehre',
    secret: process.env.COINSECRET || 'youtoothere'
})

function tradingTrans(minAmount,req,res,coin){
    mining.createTransaction({'currency1' : 'USD', 'currency2' : coin, 'amount' : minAmount, 'buyer_email': req.user.email},function(error,result){
        if(error){
            req.flash('error', error)
            res.redirect('back');
        } else {
            User.findById(req.params.id, function(err,found){
                if(err){
                    console.log(err)
                } else {
                    trade.create({
                        amount: minAmount,
                        method: coin,
                        transId: result.txn_id,
                        totalPaid: result.amount
                        
                    }, function(err, created){
                        if(err){
                            console.log(err);
                        } else {
                            created.owner.id = req.user._id;
                            created.owner.username = req.user.username;
                            created.save();
                            
                        }
                    })
                }
                
            })
            const coinMining = result;
            pendingCounter(req,res)
            res.redirect(coinMining.status_url)
        }
        
    });
}


router.post('/trading/:id', isLoggedIn, isVerified, function(req,res){
    const minAmount = parseInt(req.body.amount, 10),
          coin      = req.body.currency
          
    if(coin != 'BTC' && coin != 'ETH'){
        req.flash('error', 'Transaction unauthorized')
        return res.redirect('/dashboard/forex-trading')
    }

    if(req.user.trading === 'starter'){
        if(minAmount < 1000){
            req.flash('error', 'The amount ' + minAmount + ' is less than your ' + req.user.trading + ' trading plan minimum deposit ' + req.user.username)
            res.redirect('/dashboard/forex-trading')
        } else if(minAmount > 19999){
            req.flash('error', 'The amount ' + minAmount + ' is more than your ' + req.user.trading + ' trading plan maximum deposit ' + req.user.username)
            res.redirect('/dashboard/forex-trading')
        } else {
            tradingTrans(minAmount,req,res,coin)
        }
       
    } else if(req.user.trading === 'deluxe'){
        if(minAmount < 20000){
            req.flash('error', 'The amount ' + minAmount + ' is less than your ' + req.user.trading + ' trading plan minimum deposit ' + req.user.username)
            res.redirect('/dashboard/forex-trading')
        } else if(minAmount > 59999){
            req.flash('error', 'The amount ' + minAmount + ' is more than your ' + req.user.trading + ' trading plan maximum deposit ' + req.user.username)
            res.redirect('/dashboard/forex-trading')
        } else {
            tradingTrans(minAmount,req,res,coin)
        } 
    } else if(req.user.trading === 'expert'){
        if(minAmount < 60000){
            req.flash('error', 'The amount ' + minAmount + ' is less than your ' + req.user.trading + ' trading mining plan minimum deposit ' + req.user.username)
            res.redirect('/dashboard/' + req.params.id + '/mining')
        } else if(minAmount > 120000 ){
            req.flash('error', 'The amount ' + minAmount + ' is more than your ' + req.user.trading + ' trading plan maximum deposit ' + req.user.username)
            res.redirect('/dashboard/forex-trading')
        } else {
            tradingTrans(minAmount,req,res,coin);
        } 
    }
}) 

router.get('/tradestarter/:id', isLoggedIn, isVerified, function(req, res) {
    User.findByIdAndUpdate(req.params.id, {$set: {trading: 'starter'}}, function(error, updated){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard")
            } else {
                req.flash('success', 'Updated: You have migrated to Starter Trading plan ' + req.user.username)
                res.redirect("/dashboard/forex-trading")    
           }
    })
})

router.get('/tradedeluxe/:id', isLoggedIn, isVerified,  function(req, res) {
    User.findByIdAndUpdate(req.params.id, {$set: {trading: 'deluxe'}}, function(error, updated){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard")
            } else {
                req.flash('success', 'Updated: You have migrated to Deluxe Trading plan ' + req.user.username)
                return res.redirect("/dashboard/forex-trading")    
           }
    })
})

router.get('/tradeexpert/:id', isLoggedIn, isVerified,  function(req, res) {
    User.findByIdAndUpdate(req.params.id, {$set: {trading: 'expert'}}, function(error, updated){
        if(error){
            console.log("error occured " + error);
            return res.redirect("/dashboard")
            } else {
                req.flash('success', 'Updated: You have migrated to Expert Trading plan ' + req.user.username)
                return res.redirect("/dashboard/forex-trading");    
           }
    })
})


router.post('/updatepass/:id', isLoggedIn, isVerified, function(req, res, next) {
    asynco.waterfall([
        function(done) {
            User.findOne({_id: req.params.id}, function(err, user) {
                if(!user){
                  console.log(err);
                  return res.status(400).send('No user was found');
                };
                if(req.body.password) {
                    
                    if(req.body.password === req.body.confirmPassword){
                        user.changePassword(req.body.currentpass, req.body.password, function(err,user){
                            if(err){
                                res.status(400).send('Request unauthorized:  Your current password Input is incorrect, try again.');
                            } else {
                                
                                user.save(function(err){
                                    console.log(err)
                                    req.login(user, function(err){
                                        done(err,user)
                                    })
                                })
                                res.send('Authorized: Your password has been changed successfully')
                            }
                        })
                    } else{
                        res.status(400).send('Your passwords do not match each other')
                    }
                } else {
                    res.status(400).send('no password was provided')
                }
            })
        }

    ])
})

router.post('/reinvestcap/:id', isLoggedIn, isVerified, function(req,res){
    const password = req.body.password;
    if(password && req.user.reinvest == 'reinvest'){
        User.findById(req.params.id, function(err, found){
            if(err){
                console.log(err)
                res.status(400).send('No user found with this Id')
            } else {
                found.authenticate(password, function(err,model,passwordError){
                    if(passwordError){
                        req.flash('error', 'The given password is incorrect!!')
                        return res.redirect('back')
                    } else if(model){
                        found.reinvest = 'normal'
                        found.cryptoaddress = ''
                        found.currency = ''
                        found.investment = 'active'
                        found.save((err,success) => {
                            if(err){
                                // res.status(400).send("Request couldn't be processed, try again")
                                req.flash('error', "Request couldn't be processed, try again")
                                return res.redirect('back')
                            } else {
                                
                                if(found.withLimit == 2){
                                    req.flash('error', "Please pay your trading fee to make withdrawal")
                                    return res.redirect('back')
                                } else {
                                    reinvestment(success)
                                    req.flash('success', `Success: your investment of $${found.deposit} has been reinvested successfully.`)
                                    return res.redirect('back')
                                }
                            }
                        })
                    }
                })
            }
        })
    } else {
        req.flash('error', "Some credentials are missing")
        return res.redirect('back')
    }
})


// router.get('/reinvestcap/:id', isLoggedIn, isVerified, function(req,res){
//     // const password = req.body.password;
//     console.log('reinvesting');
    
//     if(req.user.reinvest == 'reinvest'){
//         User.findById(req.params.id, function(err, found){
//             if(err){
//                 console.log(err)
//                 res.status(400).send('No user found with this Id')
//             } else {
//                 reinvestment(found);
//             }
//         })
//     } else {
//         req.flash('error', "Some credentials are missing")
//         return res.redirect('back')
//     }
// })



router.post('/withdrawcap/:id', isLoggedIn, isVerified, function(req,res){
    console.log('working on this')
    const password = req.body.password;
    if(req.user.reinvest == 'reinvest'){
        User.findById(req.params.id, function(err, found){
            if(err){
                console.log(err)
                res.status(400).send('No user found with this Id')
            } else {
                found.authenticate(password, function(err,model,passwordError){
                    if(passwordError){
                        req.flash('error', 'The given password is incorrect!!')
                        return res.redirect('back')
                    } else if(model){
                        found.reinvest = 'normal'
                        found.cryptoaddress = req.body.cryptoaddress
                        found.currency = req.body.currency
                        found.save((err,success) => {
                            if(err){
                                // res.status(400).send("Request couldn't be processed, try again")
                                req.flash('error', "Request couldn't be processed, try again")
                                return res.redirect('back')
                            } else {
                                
                                if(found.withLimit == 2){
                                    req.flash('error', "Please pay your trading fee to make withdrawal")
                                    return res.redirect('back')
                                } else {
                                    endInvestment(found);
                                    req.flash('success', `Success: your withdrawal request is being processed.`)
                                    return res.redirect('back')
                                }
                            }
                        })
                    }
                })
            }
        })
    } else {
        req.flash('error', "Some credentials are missing")
        return res.redirect('back')
    }
})


router.post('/updateTransfer/:id', isLoggedIn, isVerified, function(req,res){
    const password = req.body.password,
          emaill    = req.body.email,
          amount   =  parseInt(req.body.amount,10)
    console.log(password,emaill)
    if(password && emaill){
        User.findById(req.params.id, function(err, found){
            if(err){
                console.log(err)
                res.status(400).send('No user found with this Id')
            } else {
                found.authenticate(password, function(err,model,passwordError){
                    if(passwordError){
                        res.status(400).send('The given password is incorrect!!')
                    } else if(model){
                        if(amount > found.deposit){
                            res.status(400).send('Amount to send is greater than your capital')
                        } else if(amount < found.deposit && amount != 0){
                            User.findOneAndUpdate({email: emaill}, {$inc: {deposit: amount}}, {new: true}, function(err,uptran){
                                if(err){
                                    console.log(err)
                                } else if(uptran) {
                                    console.log(uptran.deposit)
                                    let calc = found.deposit - amount;
                                    found.deposit = calc;
                                    found.save((err,success) => {
                                        if(err){
                                            res.status(400).send("Transfer discharge unsuccessful")
                                        } else {
                                            res.send('Transfer successful')
                                        }
                                    })
                                } else {
                                    res.status(400).send("No Tradevity investor with that email address exists")
                                }
                            })
                        }
                    }
                })
            }
        })
    } else {
        res.status(400).send('some credentials are missing')
    }
})


router.post('/updateEmail/:id', isLoggedIn, isVerified, function(req,res){
    const password = req.body.password,
          email    = req.body.email
    console.log(password,email)
    if(password && email){
        User.findById(req.params.id, function(err, found){
            if(err){
                console.log(err)
                res.status(400).send('No user found with this Id')
            } else {
                found.authenticate(password, function(err,model,passwordError){
                    if(passwordError){
                        res.status(400).send('The given password is incorrect!!')
                    } else if(model){
                        found.email = email
                        found.save((err,success) => {
                            if(err){
                                res.status(400).send("Check your Email Address and try again")
                            } else {
                                res.send('Email updated successfully')
                            }
                        })
                    }
                })
            }
        })
    } else {
        res.status(400).send('some credentials are missing')
    }
})

// router.delete("/history/:User_id",isLoggedIn, isVerified, function(req,res){
//     if(req.isAuthenticated){
//         History.remove({}).where('owner.id').equals(req.user._id).exec(function(err,suc){
//             if(err){
//                 console.log(err)
//             } else {
//                 res.redirect("back")
//             }
//         })
//     }
// });


    
// ================================= MIDDLE WARE ==============
function isVerified(req,res,next){
    var link = '/verification/' 
    if(req.user.active === "true"){
        return next()
    } else {
        req.flash('error', 'Request unauthorized:' +  ' your mail link is yet to be verified, <a href="'+ link +'"> Click here to resend the link</a>.')
        res.redirect('/login')
    }
}

function isLoggedIn(req, res, next){
    if(req.isAuthenticated()){
        // return next();
        if(req.user.twofactor == true){
            if(req.session.secondFactor){
                return next();
            } else {
                if(req.xhr === true){
                    return res.status(500).send('Authenticate two factor to continue');
                }
                req.flash('error', 'Authenticate two factor to continue')
                return res.redirect(`/login`)
            }
        } else {
            return next();
        }
    }
    req.flash("error", "Please login first to do that")
    res.redirect('/login');
}

module.exports = router;