var express               = require('express'),
    router                = express.Router(),
    passport              = require('passport'),
    User                  = require('../models/user'),
    crypto                = require("crypto"),
    multer                = require("multer"),
    nodemailer            = require("nodemailer"),
    asynco                = require("async"),
    cloudinary            = require("cloudinary"),
    country               = require('geoip-lite'),
    sniffr                = require('sniffr'),
    g2fa                  = require('../models/g2fa'),
    TopStrategy           = require('passport-totp'),
    base32                = require('thirty-two')
    
    
let { signedUp } = require('../routes/mail');
let { refIncrement } = require('../routes/mail');
let { registerRefferedby } = require('../routes/affiliate')
    
// ======================== LOGIN LOGICS HERE ===============

// passport.authenticate('local', { failureFlash: 'Invalid username or password.' });
// passport.authenticate('local', { successFlash: 'Welcome!' });

let s = new sniffr();
var {logNotific}  = require('./mail');


router.post('/loginClient_12', function(req, res, next) {
    const userAgent = req.headers['user-agent'];
    s.sniff(userAgent);
    var ip = req.headers['x-forwarded-for'] || '124.9087.908'
    var firstip = ip.split(",")
    console.log(firstip)
    var location = country.lookup(firstip[0]);
    // let location = {country: 'cont'}
    
    // if(req.isAuthenticated() && req.user.twofactor != true){
    //     if(req.xhr === true){
    //         return res.status(400).send(`You're still logged in.`)
    //     }
    //     req.flash('error', `You're still logged in`)
    //     return res.redirect('/login');
    // }
    
    passport.authenticate('local', function(err, user, info) {
    if (err) { return next(err); }
    if (!user) {
        if(req.xhr === true){
            return res.status(400).send('Password or Username is incorrect')
        }
        req.flash('error', 'Password or Username is incorrect')
        return res.redirect('/login'); 
    }
    req.logIn(user, function(err) {
        // console.log(req.headers)
      if(err) {
          console.log(err);
          if(req.xhr === true){
                return res.status(400).send('Password or Username is incorrect')
          }
          req.flash('error', 'username or password is incorrect')
          return next(err); 
      }
      if(req.xhr === true){
            // console.log(req.session.id);
            (req.user.logEmail == 'active') ? 
            logNotific(s.os.name,s.os.versionString,s.browser.name,ip,location,req.user.email) : false
            if(req.user.twofactor == true){
                return res.send({message: 'Authorized, please authenticate 2fa to continue', url: `/login-otp/${req.user._id}`, name: req.user.username});
            } else {
                return res.send({message: 'Authorized, Going Aboard', img: req.user.userimage, name: req.user.username});
            }
            
      } else {
            (req.user.logEmail == 'active') ? 
            logNotific(s.os.name,s.os.versionString,s.browser.name,ip,location,req.user.email) : false
            if(req.user.twofactor == true){
                req.flash('success', 'Authourized, please authenticate 2FA to continue');
                res.redirect(`/authenticate-two_factor/${req.user._id}`);
            }
            return res.redirect('/dashboard');  
      }
    });
  })(req, res, next);
});


router.get('/authenticate-two_factor/:id', isLoggedIn, function(req,res){
    res.render('login2fa')
})

//AUTHENTICATION ROUTES

// =================== SIGN UP LOGICS HERE ==============

var isString = (str)=>{
    return typeof str === 'string' && str.trim().length > 0;
}

router.post("/registeral2", function(req,res){
    const userna = req.body.username.toLowerCase();
    var newUser = new User({username: userna, phone: req.body.phone, email: req.body.email,
                  address: req.body.address, zipcode: '0000', fullname: req.body.fullname, country: req.body.country, 
                  reference: req.body.reference});
    if(req.body.password === req.body.confirmPass){
        if(!isString(newUser.username) || !isString(req.body.password) || !isString(newUser.email)){
            console.log('error')
            if(req.xhr === true){
                res.status(400).send('Some details are incomplete')
            } else {
                req.flash('error', 'Some details are incomplete')
                res.redirect('back')
            }
        } else {
            User.findOne({email: newUser.email}, function(err,found){
                if(!found){
                    
                    // if(req.body.referralId){
                    //     User.findById(req.body.referralId, function(err,fin){
                    //         if(err){
                    //             return res.status(400).send('Referral Id Incorrect: No user found with the provided Id')
                    //         } else if (fin){
                    //             console.log('user found')
                    //         }
                    //     })
                    // }
                    
                    User.register(newUser, req.body.password, function(error, user){
                        if(error){
                            if(req.xhr === true){
                                res.status(400).send(`${error.message}`)
                            } else {
                                req.flash("error", `${error.message}`)
                                return res.redirect("/register")   
                            }
                        } else {
                            signedUp(req.body);
                            // console.log(req.cookies.compRef);
                            if(req.body.referralId){
                                
                                // registerRefferedby(user._id,req.cookies.compRef)
                                let refo = req.body.referralId
                                
                                registerRefferedby(user._id,req.body.referralId)
                                console.log('checking on cookies')
                                User.findByIdAndUpdate(refo, {$inc: {refCount: 1}}, {new: true}, (err,found)=>{
                                    if(err){
                                        console.log(err)
                                        user.remove();
                                        return res.status(400).send('Referral Id Incorrect: No user found with the provided Id')
                                    } else {
                                        console.log('incremented the count of the user')
                                        let refUser  = {username: found.username, email: found.email},
             
                                            referred = {fullname: user.fullname, country: user.country}
                                        refIncrement(refUser,referred)
                                        console.log(found.refCount);
                                        passport.authenticate("local")(req, res, function(){
                                            console.log('registered successfully')
                                            if(req.xhr === true){
                                                return res.send({message: 'Registered successfully', link: '/verification', twofac: `${user._id}`})
                                            } else {
                                                return res.redirect('/verification')   
                                            }
                                        })
                                    }
                                })
                            } else {
                                console.log('no compref or referral ID')
                                passport.authenticate("local")(req, res, function(){
                                    console.log('registered successfully')
                                    if(req.xhr === true){
                                        return res.send({message: 'Registered successfully', link: '/verification', twofac: `${user._id}`})
                                    } else {
                                        return res.redirect('/verification')   
                                    }
                                })
                            }
                               
                        }
                        
                    })
                } else if(found) {
                    console.log(found)
                    if(req.xhr === true){
                        return res.status(400).send('An investor with that email address already exist')
                    }
                    req.flash('error', 'An investor with that email address already exist')
                    return res.redirect('back')
                } 
            })
        }
    } else {
        if(req.xhr === true){
            return res.status(400).send('Passwords do not match')
        } else {
            req.flash('error', 'Passwords do not match')
            res.redirect('back')   
        }
    }
})

// ================================= MIDDLE WARE ==============

function isLoggedIn(req, res, next){
    if(req.isAuthenticated()){
        return next();
    }
    req.flash("error", "Please login first to do that")
    res.redirect('/login');
}

// ========================================================  UPDATE USER IMAGE PROFILE ============

cloudinary.config({
    cloud_name: 'dr6bmp4nn',
    api_key: process.env.CLOUDIMGKEY,
    api_secret: process.env.CLOUDIMGSECRET,     	
})

var storage = multer.diskStorage({
        filename: function(req, file, callback) {
            callback(null, file.originalname)
        }
    })
    
var imagefilter = function (req, file, cb) {
    if(!file.originalname.match(/\.(jpg|jpeg|png)$/i)){
        return cb('only image files are accepted here', false)
    } else {
        cb(null, true);
    }
}

var upload = multer({storage: storage, fileFilter: imagefilter, limits:{
        fileSize: 1024 * 1024
    }
});

let finalUrl = upload.single('userimage');

router.put("/dashboard/:id/updateUserImg", isLoggedIn, isVerified, function(req,res){
    
    finalUrl(req,res, function(err){
        if(err){
            console.log(err)
            return res.send('Please note that only image files are supported(.jpg,.png,.jpeg..)')
        } else {
            if(req.body.userimage && req.body.imageUrl > 1){
                console.log('two files exist')
                res.status(400).send('Please select either image uplaod or image url')
            } else if(req.body.imageUrl > 1){
                let imgUrl = req.body.imageUrl;
                    User.findByIdAndUpdate(req.params.id,{userimage: imgUrl}, function(error, updated){
                    if(error){
                        console.log("error occured " + error);
                        res.status(400).send('error finding your path')
                    } else {
                        updated.save()
                        res.send(imgUrl)
                    }
                })
            } else {
                cloudinary.uploader.upload(req.file.path)
                .then(function(result){
                    let imgUrl = req.body.userimage = result.secure_url;
                    console.log(imgUrl);
                    User.findByIdAndUpdate(req.params.id,{userimage: imgUrl}, function(error, updated){
                        if(error){
                            console.log("error occured " + error);
                            res.status(400).send('Update failed, please try again')
                        } else {
                            updated.save()
                            return res.send(imgUrl);
                        }
                    })
                })
                .catch(function(error){
                    console.log(error);
                })
            }
        }
    })
    
})


// ================================= MIDDLE WARE ==============

function isVerified(req,res,next){
    var link = '/verification/' 
    if(req.user.active === "true"){
        return next()
    } else {
        req.flash('error', 'Request unauthorized:' +  ' your investment account is yet to be verified, <a href="'+ link +'"> Click here to resend the link</a>.')
        res.redirect('/login')
    }
}

function isLoggedIn(req, res, next){
    if(req.isAuthenticated()){
        return next();
    }
    req.flash("error", "Please login first")
    res.redirect('/login');
} 

module.exports = router

// FOR LOCKING OF ACCOUNT
// sessionStore = express.session.MemoryStore();
// sessionStore.get(id, function(err, sess) {
//   sess.destroy (function (err) {

//   });
// });

