var express = require('express'),
    router  = express.Router(),
    User                = require('../models/user'),
    Coinpayments        = require("coinpayments"),
    aihistory           = require('../models/aihistory'),
    cryptoRand              = require('crypto-random-string')
    
    

// AI BOT SET UP

router.get('/:id/ai', isLoggedIn, isVerified, function(req,res){
    User.findById(req.params.id, function(err, found){
        if (err){
            console.log(err);
            return res.redirect('/dashboard')
        } else {
            aihistory.find({}).where('owner.id').equals(req.user._id).exec(function(err,found){
                if(err){
                    console.log(err);
                } else {
                    return res.render("dash-web/aibot", {ai: found})
                    
                }
                
            })
        }
    })
})

router.post('/:id/bot/safe', isLoggedIn, isVerified, (req,res)=>{
    User.findById(req.params.id, function(err, fou){
        if(err){
            console.log(err)
            return res.redirect('back')
        } else if(fou) {
            fou.ai.plan = "safe";
            fou.save((err,save)=>{
                if(err){
                    console.log(err)
                } else {
                    return res.send({message: 'Ai plan migrated to safe mode', plan: 'safe'});
                }
            })
        }
    })
})

router.post('/:id/invest/cripup', isLoggedIn, isVerified, (req,res)=>{
    let data = req.body;
    User.findById(req.params.id, function(err, fou){
        if(err){
            console.log(err)
            return res.redirect('back')
        } else if(fou) {
            fou.cryptoaddress = data.cryptoaddress;
            fou.currency = data.currency
            fou.save((err,save)=>{
                if(err){
                    console.log(err)
                    return res.status(400).send("Your Investment payout settings couldn't be updated successfully")
                } else {
                    return res.send({message: 'Investment payout settings updated successfully'});
                }
            })
        }
    })
})

router.post('/:id/ai/arimoup', isLoggedIn, isVerified, (req,res)=>{
    let data = req.body;
    console.log(req.body.botaddress)
    User.findOneAndUpdate({_id: req.user.id}, {$set: {botaddress: data.botaddress}}, (err,suc)=>{
        if(err){
            console.log(err)
            return res.status(400).send("Your Ai Investment payout settings couldn't be updated")
        } else if(suc){
            return res.send({message: 'Ai Investment payout settings updated successfully'});
        }
    })
    // User.findById(req.params.id, function(err, found){
    //     if(err){
    //         console.log(err)
    //         return res.redirect('back')
    //     } else if(found) {
    //         found.botaddress = data.botaddress;
    //         found.save((err,save)=>{
    //             if(err){
    //                 console.log(err)
    //                 return res.status(400).send("Your Ai Investment payout settings couldn't be updated successfully")
    //             } else {
    //                 return res.send({message: 'Ai Investment payout settings updated successfully'});
    //             }
    //         })
    //     }
    // })
})


router.post('/automaticpayout',isLoggedIn, isVerified, function(req,res){
    let id = req.user._id;
    if(req.user.paymethod != 'manual'){
        return res.status(400).send('This feature has already been set to automatic mode');
    } else if(req.user.paymethod == 'manual'){
        if(req.user.cryptoaddress != null || req.user.cryptoaddress.length > 0){
            User.findOneAndUpdate({_id: id},{$set: {paymethod: 'automatic'}})
            .then(function(suc){
                return res.send('Investment payout mode has been set to Automatic mode successfully!')
            })
            .catch(function(err){
                return res.status(400).send('Try again, this service might be currently unavailable')
            })
        } else {
            return res.status(400).send('You need to set an investment payout wallet address in order to make use of automatic mode')
        }
    }
})

router.post('/manualpayout', isLoggedIn, isVerified, function(req,res){
    let id = req.user._id;
    if(req.user.paymethod == 'manual'){
        return res.status(400).send('This feature has already been set to manual mode');
    } else if(req.user.paymethod == 'automatic'){
        User.findOneAndUpdate({_id: id},{$set: {paymethod: 'manual'}}, function(err,suc){
            if(err){
                return res.status(400).send('Try again, this service might currently not be available')
            } else {
                res.send('Investment payout mode has been set to Manual mode successfully!')
            }
        })
    }
})



router.post('/:id/bot/moderate', isLoggedIn, isVerified, (req,res)=>{
    User.findById(req.params.id, function(err, fou){
        if(err){
            console.log(err)
            return res.redirect('back')
        } else if(fou) {
            fou.ai.plan = "moderate";
            fou.save((err,save)=>{
                if(err){
                    console.log(err)
                } else {
                    return res.send({message: 'Ai plan migrated to moderate mode', plan: 'moderate'});
                }
            })
        }
    })
})

router.post('/:id/bot/aggressive', isLoggedIn, isVerified, (req,res)=>{
    User.findById(req.params.id, function(err, fou){
        if(err){
            console.log(err)
            return res.redirect('back')
        } else if(fou) {
            fou.ai.plan = "aggressive";
            fou.save((err,save)=>{
                if(err){
                    console.log(err)
                } else {
                    return res.send({message: 'Ai plan migrated to aggressiv mode', plan: 'aggressive'});
                }
            })
        }
    })
})

var client = new Coinpayments({
    key: process.env.COINKEY || 'hellothere',
    secret: process.env.COINSECRET || 'youtoothere'
});

router.post('/:id/ai/botsetup', isLoggedIn, isVerified, function(req,res){
    let price = parseInt(req.body.amount, 10);
    if(price && price > 2999){
        client.createTransaction({'currency1' : 'USD', 'currency2' : 'BTC', 'amount' : price, 'buyer_email' : req.user.email},function(err,result){
            if(err){
                console.log(err)
                req.flash('error', err);
                res.status(400).send(err);
            } else {
                User.findById(req.params.id, function(err,found){
                    if(err){
                        console.log(err)
                    } else {
                        aihistory.create({
                            amount: price,
                            action: 'deposit',
                            transId: result.txn_id,
                            coinAmount: result.amount
                            
                        }, function(err, created){
                            if(err){
                                console.log(err);
                            } else {
                                created.owner.id = req.user._id;
                                created.owner.username = req.user.username;
                                created.save();
                                return res.send({message: 'Redirecting to payment page', url: result.status_url});
                            }
                        })
                    }
                    
                })
                
                // var coinPayment = result;
                // return res.redirect(coinPayment.status_url)
            }
        });

    } else if(price < 3000){
        return res.status(400).send('Amount must not be less than 3000 USD')
    } else {
        
        return res.status(400).send('An amount is needed')
    }
})

// AI BOT SETUP ENDS

    

// ================================= MIDDLE WARE ==============
function isVerified(req,res,next){
    var link = '/verification/' 
    if(req.user.active === "true"){
        return next()
    } else {
        req.flash('error', 'Request unauthorized:' +  ' your mail link is yet to be verified, <a href="'+ link +'"> Click here to resend the link</a>.')
        res.redirect('/login')
    }
}

function isLoggedIn(req, res, next){
    if(req.isAuthenticated()){
        return next();
    } else if(req.xhr === true){
        var data = {status: 'error', message: "You are currently unauthorized for this request"}
        res.send(data)
    } else {
        req.flash("error", "Please login first to do that")
        res.redirect('/login');
    }
}


module.exports = {router}