var express = require('express'),
    router  = express.Router(),
    User                = require('../models/user'),
    Coinpayments        = require("coinpayments"),
    aihistory           = require('../models/aihistory'),
    cryptoRand              = require('crypto-random-string')
    
    

// AI BOT SET UP

router.get('/:id/ai', isLoggedIn, isVerified, function(req,res){
    User.findById(req.params.id, function(err, found){
        if (err){
            console.log(err);
            return res.redirect('/dashboard')
        } else {
            return res.render("dash-web/aibot")
        }
    })
})

router.post('/:id/bot/safe', isLoggedIn, isVerified, (req,res)=>{
    User.findById(req.params.id, function(err, fou){
        if(err){
            console.log(err)
            return res.redirect('back')
        } else if(fou) {
            fou.ai.plan = "safe";
            fou.save((err,save)=>{
                if(err){
                    console.log(err)
                } else {
                    return res.send({message: 'Ai plan migrated to safe mode', plan: 'safe'});
                }
            })
        }
    })
})

router.post('/:id/bot/moderate', isLoggedIn, isVerified, (req,res)=>{
    User.findById(req.params.id, function(err, fou){
        if(err){
            console.log(err)
            return res.redirect('back')
        } else if(fou) {
            fou.ai.plan = "moderate";
            fou.save((err,save)=>{
                if(err){
                    console.log(err)
                } else {
                    return res.send({message: 'Ai plan migrated to moderate mode', plan: 'moderate'});
                }
            })
        }
    })
})

router.post('/:id/bot/aggressive', isLoggedIn, isVerified, (req,res)=>{
    User.findById(req.params.id, function(err, fou){
        if(err){
            console.log(err)
            return res.redirect('back')
        } else if(fou) {
            fou.ai.plan = "aggressive";
            fou.save((err,save)=>{
                if(err){
                    console.log(err)
                } else {
                    return res.send({message: 'Ai plan migrated to aggressive mode', plan: 'aggressive'});
                }
            })
        }
    })
})

router.post('/:id/ai/botsetup', isLoggedIn, isVerified, function(req,res){
    let price = req.body.amount;
    if(price && price > 2999){
        
    } else {
        return res.status(400).send('An amount is needed')
    }
})

// AI BOT SETUP ENDS

    

// ================================= MIDDLE WARE ==============
function isVerified(req,res,next){
    var link = '/verification/' 
    if(req.user.active === "true"){
        return next()
    } else {
        req.flash('error', 'Request unauthorized:' +  ' your mail link is yet to be verified, <a href="'+ link +'"> Click here to resend the link</a>.')
        res.redirect('/login')
    }
}

function isLoggedIn(req, res, next){
    if(req.isAuthenticated()){
        return next();
    } else if(req.xhr === true){
        var data = {status: 'error', message: "You are currently unauthorized for this request"}
        res.send(data)
    } else {
        req.flash("error", "Please login first to do that")
        res.redirect('/login');
    }
}


module.exports = {router}