var express             = require('express'),
    router              = express.Router(),
    normal              = require('../models/normal'),
    User                = require('../models/user'),
    affiliate           = require('../models/affiliate'),
    Coinpayments        = require("coinpayments")
    
    
let { referralFailed }      = require('../routes/mail');
let { referralComplete }    = require('../routes/mail'); 
let { nfploan }             = require('../routes/mail'); 
    
// let createAffiliate = function(){
//     console.log("text")
//     var i;
    
//     for (i = 0; i < 5; i++){
//         affiliate.create({
//             amount: 90,
//             'owner.id': "5da285b69c7730122d7eedba",
//             transId: "CPEF1ATTL027KZP1SYWL2MIYKP"
//         },function(err,created){
//             if (err) console.log(err);
//             else console.log(created);
//         });
//     }
// }

let  {endInvestment}        = require('./mail');

router.post('/nfp/:id/withdraw', isLoggedIn, isVerified, (req,res)=>{
    
    User.findById(req.params.id, (err,found)=>{
        if(err){
            console.log(err)
            req.flash('error', 'User not found')
            return res.redirect('back')
        } else if(found){
            if (req.body.amountprofit > found.nfp.profit){
                req.flash('error', "Insufficient funds for the withdrawal amount");
                return res.redirect('back');
            } else {
                console.log('withdrawing successfully')
                req.flash('success', 'Withdrawal request received and will be processed soon')
                endInvestment(found);
                return res.redirect('back')
            }
            // if(found._id == process.env.LOANNFP || '5e7d35304f6a0170ef9fc'){
            //     console.log('process email request')
            //     nfploan(found,'30,000.00',req.body.amountprofit)
            //     req.flash('error', `Transaction: "unable to process withdrawal request due to loan debt"`)
            //     res.redirect('back')
            // } else {
            //     if (req.body.amountprofit > found.nfp.profit){
            //         req.flash('error', "Insufficient funds for the withdrawal amount");
            //         return res.redirect('back');
            //     } else {
            //         console.log('withdrawing successfully')
            //         req.flash('success', 'Withdrawal request received and will be processed soon')
            //         endInvestment(found);
            //         return res.redirect('back')
            //     }
            // }
        }
    })
})

router.post('/nfp/:id/importfunds', isLoggedIn, isVerified, function(req,res){
    console.log('reached nfp import')
    let amount = parseInt(req.body.amount,10);
    
    if(req.user.investment == 'active'){
        req.flash('error', "Funds, can't be imported, you have an active crypto Investment")
        return res.redirect('back')
    } else if (amount > req.user.deposit){
        req.flash('error', 'Amount is greater than your Investment capital')
        return res.redirect('back')
    } else if(amount < req.user.deposit || req.user.deposit == amount){
        User.findOneAndUpdate({_id: req.params.id}, {$inc: {deposit: -amount,'nfp.capital': amount}}, {new: true}, function(err,updated){
            if(err){
                console.log(err)
            } else if(updated){
                console.log(updated.nfp.capital)
                console.log(updated.deposit)
                req.flash('success', `Funds imported successfully ( $${amount} )`);
                return res.redirect('back')
            }
        })
    }
})

router.post('/nfp/:id/exportfunds', isLoggedIn, isVerified, function(req,res){
    console.log('reached nfp export')
    let amount = parseInt(req.body.amount,10);
    if(amount > req.user.nfp.capital){
        req.flash('error', 'Amount is greater than your NFP capital')
        return res.redirect('back')
    } else if(req.user.nfp.active == "active") {
        
        req.flash('error', `NFP Active: NFP funds cannot be exported while Investment is active.`)
        return res.redirect('back')
        
    } else if(amount < req.user.nfp.capital || req.user.nfp.capital == amount){
        User.findOneAndUpdate({_id: req.params.id}, {$inc: {deposit: amount,'nfp.capital': -amount}}, {new: true}, function(err,updated){
            if(err){
                console.log(err)
            } else if(updated){
                console.log(updated.nfp.capital)
                console.log(updated.deposit)
                req.flash('success', `NFP Funds Exported Successfully ( $${amount} )`);
                return res.redirect('back')
            }
        })
    }
})

let createAffiliateTrans = function (refferedby,data){
    
    User.findById(refferedby, (err,found)=>{
        if(err){
            console.log(err);
        } else if(found){
            affiliate.create({
                transId: data.transId,
                amount: data.amount,
                'owner.id': refferedby,
            },function(err,created){
                if (err) console.log(err);
                else console.log("created affiliate-trans");
            });
        }
    })
    
}

let registerRefferedby = function (user,referredby){
    User.findByIdAndUpdate(user, {'referral.referredby': referredby}, function(err,result){
        if(err){
            console.log(err)
        } else if(result){
            console.log('registered refferedby')
        }
    })
}


// createAffiliate();

router.get('/dashboard/non-farm', isLoggedIn, isVerified, function(req,res){
    User.findById(req.user.id, function(error,found){
        if(error){
            console.log(error);
        } else {
            affiliate.find({}).where('owner.id').equals(req.user._id).exec(function(err,found){
                if(err){
                    console.log(err);
                } else {
                    // console.log(found)
                    return res.render("dash-web/nfp", {trade: found});
                }
                
            })
        }
    })
})

router.get('/dashboard/referral-program', isLoggedIn, isVerified, function(req,res){
    
    User.findById(req.user.id, function(error,found){
        if(error){
            console.log(error);
        } else {
            affiliate.find({}).where('owner.id').equals(req.user._id).exec(function(err,found){
                if(err){
                    console.log(err);
                } else {
                    // console.log(found)
                    return res.render("dash-web/referral", {trade: found});
                }
                
            })
            
        }
    })
})

router.post('/dashboard/:id/reffwithrawal', function(req,res){
    
})

function referralCancelled(identiy,data){
    console.log(data)
    User.findById(identiy, function(err, found) {
        if(err){
            console.log(err)
        } else if(found){
            let sendInfo = data;
            sendInfo.email = found.email;
            sendInfo.investor = found.username;
            if(sendInfo.username){
                referralFailed(sendInfo);
            } else {
                console.log(`didn't complete parsing of data on time`)
            }
        }
    })
}

function referralCompleted(identify,data,percent){
    console.log(data);
    let sendInfo = data;
        
    let  amount = parseInt(data.amount,10),
         times  = parseInt(percent,10),
         commit = amount/100*times,
         final  = commit.toFixed()
    
    User.findByIdAndUpdate(identify,{$inc: {'referral.profit': final, 'referral.finished': 1, 'referral.transactions': 1}}, function(err,updated){
        if(err){
            console.log(err)
        } else if(updated){
            sendInfo.email = updated.email;
            sendInfo.username = updated.username;
            return referralComplete(sendInfo,final);
        }
    })
}

// ================================= MIDDLE WARE ==============
function isVerified(req,res,next){
    var link = '/verification/' 
    if(req.user.active === "true"){
        return next()
    } else {
        req.flash('error', 'Request unauthorized:' +  ' your mail link is yet to be verified, <a href="'+ link +'"> Click here to resend the link</a>.')
        res.redirect('/login')
    }
}

function isLoggedIn(req, res, next){
    if(req.isAuthenticated()){
        // return next();
        if(req.user.twofactor == true){
            if(req.session.secondFactor){
                return next();
            } else {
                if(req.xhr === true){
                    return res.status(500).send('Authenticate two factor to continue');
                }
                req.flash('error', 'Authenticate two factor to continue')
                return res.redirect(`/login`)
            }
        } else {
            return next();
        }
    }
    req.flash("error", "Please login first to do that")
    res.redirect('/login');
}
    
module.exports = {router, createAffiliateTrans, registerRefferedby, referralCancelled, referralCompleted};
