// ======================================== BITCOIN USERS =====================

var mongoose = require('mongoose'),
    validator = require('validator'),
    passortLocalMongoose = require("passport-local-mongoose")

var UserSchema = new mongoose.Schema({
    fullname: {type: String, required: [true, 'A name is required for this account']},
    username: {type: String, required: [true, 'A user name is required']},
    phone: {type: String, required:[true, 'A phone number is required'], minlength: 3},
    address: {type: String},
    email: {type: String,
            required: [true,'An email is required'],
            minlength: 1, unique: true,
            validate:{
                validator: validator.isEmail,
                message:'{VALUE} is not a valid email address'
            }
    },
    userimage: {type: String, default: "https://res.cloudinary.com/sniper/image/upload/v1521503621/l3tojf8qbopjsyprvaxy.png"},
    zipcode: {type: Number, required: [true, 'zipcode cannot be empty'], trim: true},
    country: {type: String, required: [true, 'Country field is required']},
    password: {type: String, minlength: 6},
    reference: String,
    active: {type: String, default: "false"},
    date: {type: Date, default: Date.now},
    verificationToken: String,
    resetPasswordToken: String,
    resetPasswordExpires: Date,
    logEmail: {type: String, default: "active"},
    miningPending: {type: Number, default: 0},
    plan: {type: String, default: "starter"},
    trading: {type: String, default: "starter"},
    total: {type: Number, default: 0},
    withLimit: {type: Number, default: 0},
    pending: {type: Number, default: 0},
    profit: {type: Number, default: 0},
    available: {type: Number, default: 0},
    deposit: {type: Number, default: 0},
    withdrawn: {type: Number, default: 0},
    refCount: {type: Number, default: 0},
    referral: {
        profit: {type: Number, default: 0},
        transactions: {type: Number, default: 0},
        finished: {type: Number, default: 0},
        referredby: {type: String, default: 'none'}
    },
    ai: {
        plan: {type: String, default: 'safe'},
        profit: {type: Number, default: 0},
        deposit: {type: Number, default: 0},
        last: {type: Number, default: 0},
        available: {type: Number, default: 0},
        status: {type: String, default: 'down'}
    },
    cryptoaddress: {type: String},
    paymethod: {type: String, default: 'manual'},
    currency: {type: String, default: 'Bitcoin'},
    botaddress: {type: String},
    investment: {type: String, default: 'inactive'},
    reinvest: {type: String, default: 'normal'},
    twofactor: {type: Boolean, default: false},
    capwithdraw: 0,
    capreinvest: 0,
    perRoi: {type: String, default: '4'},
    nfp: {
        en: {type: String, default: 'disabled'},
        active: {type: String, default: 'inactive'},
        profit: 0,
        capital: 0,
        tier: {type: String, default: 'first-class'}
    }
})

UserSchema.plugin(passortLocalMongoose);

module.exports = mongoose.model("User", UserSchema)