/* global $ WAValidator jQuery*/


function closeAlert() {
    // var close = document.getElementById("show-to");
    $(".show-alert-message").fadeOut(1000);
}

$('#change-photo').click( () =>{
    $('.img-change').fadeToggle(500)
})

$('#get_file').on('click', function(){
    $('#my-file').click();
})

$('#sett').on('click', function(){
    $('.edit-main-content, .payout_setup').fadeOut(50, () => {
        $('.settings-account').fadeIn(50);
        $('#sett-focus').focus();
    });
})

$('#payout').on('click', ()=>{
    $('.edit-main-content, .settings-account').fadeOut(50, ()=>{
        $('.payout_setup').fadeIn((50));
    })
})

// $('#payout').text('');

$('#pass-change').submit(function(event){
    event.preventDefault()
    Passwordvalidate()
})

function Passwordvalidate(){
    let current = document.getElementById('sett-focus').value;
    let newpass = document.getElementById('newpass').value;
    let confirm = document.getElementById('confirm-pass').value;
    
    if(current == '' || newpass !== confirm){
        alertError('Request denied: Your passowrds do not match each other, try again')
        return false
    } else if($('#newpass').val().length < 6){
        alertError('Request denied: Your passowrds should be more than six characters')
        return false
    } else{
        alertSuccess('Updating your Account Password..')
        $.post(`/updatepass/${owner}`,{
            currentpass: current,
            password: newpass,
            confirmPassword: confirm
        }, function(data, status){
            console.log(data, status)
            if(data.status === "error"){
                alertError(data.message)
            } else {
                alertSuccess(data)
                if(data == 'Authorized: Your password has been changed successfully'){
                    document.getElementById('sett-focus').value = ""
                    document.getElementById('newpass').value = "";
                    document.getElementById('confirm-pass').value = "";
                }
            }
        })
        .fail(function(error) {
            alertError(error.responseText || 'Check your Internet Connection');
        })
        
    }
    return false;
}

let owner = document.getElementById('owner').innerText

function alertError(message){
    $('#show-to-success').fadeOut(function(){
        $('#show-to').fadeIn()
        $('#error-text').text(message)  
    })
}

function alertSuccess(message){
    $('#show-to').fadeOut(function(){
        $('#show-to-success').fadeIn()
        $('#success-text').text(message)  
    })
}

function getExtension(filename) {
    var parts = filename.split('.');
    return parts[parts.length - 1];
}

function isImage(filename) {
    var ext = getExtension(filename);
    switch (ext.toLowerCase()) {
    case 'jpg':
    case 'gif':
    case 'jpeg':
    case 'png':
        return true;
    }
    return false;
}

$('#email-changer').on('click', function() {
    $('.check-bitcoin').fadeIn(100)
})

$('#image-upload').submit(function(event){
    event.preventDefault()
    var title = $('#customupload').text(); 
    
    if(!uploadField.files[0]){
        alertError('Please select an image file')
    } else if(!isImage($('#my-file').val())){
        alertError('Error: Please note that only image files are supported(.jpg,.png,.jpeg..)')
    } else {
        alertSuccess('Image uploading: your image is been uploaded')
        imageUpload($('#image-upload'),title)
    } 
    
    return false
})

$('.withdraw-out').click(function(){
    $('.withdraw').fadeIn(100)
})

function imageUpload(file,title){
    $(file).ajaxSubmit({
        data: {title: title},
        contentType: 'application/json',
        error: function(error){
            alertError("Account avatar could not be updated" || 'Check your Internet Connection')
        },
        success: function(data){
            if(data.status === "error"){
                alertError(data.message)
            } else {
                console.log(data);
                if(data !== 'Please note that only image files are supported(.jpg,.png,.jpeg..)' || 
                data !== 'Please input a correct url with an image file extension'){
                    $('img.chimg').attr('src', data)
                    alertSuccess('Avatar updated: your profile avatar has been updated successfully')
                } else {
                    alertError(data)
                }   
            }
        }
        });
}

let uploadField = document.getElementById("my-file");
let changeImg = document.getElementById("change-img").src;
let uploadName = document.getElementById("customupload");

uploadField.onchange = function(){
    if(this.files[0].size > 307090){
        alertError('Image File: Please choose an image file between 500kb to 999kb to continue')
        this.value = ""
    } else {
        uploadName.innerText = this.value
        readURL(this);
    }
}

function readURL(input) {
  if (input.files && input.files[0]) {
    var reader = new FileReader();
    reader.onload = function(e) {
      $('#change-img').attr('src', e.target.result);
    }
    reader.readAsDataURL(input.files[0]);
  }
}

$('#img-option').on('click', () => {
    $('#url-option').fadeIn(20);
    $('#url-focus').focus()
})

$('#perso').on('click', function(){
    $('.settings-account, .payout_setup').fadeOut(50, () => {
        $('.img-change, #url-option').fadeOut(50)
        $('.edit-main-content').fadeIn(50);
        $('#perso-focus').focus();
    });
})

$('#perso, #sett, #payout').on('click', function(){
    $('#perso, #sett, #payout').removeClass('active-edit').addClass('not-active')
    $(this).addClass('active-edit')
})

$('#cryptoupdate').submit(function(event){
    event.preventDefault();
    let address = document.getElementById('coinAddress').value,
        currency = document.getElementById('investCurrency').value
    
    var valid = WAValidator.validate(address, currency, 'both');
    if(valid){
        alertSuccess('Updating investment payout settings')
        if(isRealString(address)){
            $(this).ajaxSubmit({
                method: 'POST',
                error: function(error){
                    alertError(error.responseText || 'Check your Internet Connection')
                },
                success: function(data){
                    if(data.status === "error"){
                        alertError(data.message)
                    } else {
                        alertSuccess(data.message)
                    }
                }
            })
        } else {
            alertError('Please input a wallet address to continue');
        }
    } else {
        alertError(`The provided wallet address is not a Valid ${currency} address`)
    }
})

$('#aiupdateset').submit(function(event){
    event.preventDefault();
    let address = document.getElementById('aiAddress').value,
        currency = 'BTC'
    var valid = WAValidator.validate(address, currency, 'both');
    if(valid){
        alertSuccess('Updating ai payout settings')
        if(isRealString(address)){
            $(this).ajaxSubmit({
                method: 'POST',
                error: function(error){
                    alertError(error.responseText || 'Check your Internet Connection')
                },
                success: function(data){
                    if(data.status === "error"){
                        alertError(data.message)
                    } else {
                        alertSuccess(data.message)
                    }
                }
            })
        } else {
            alertError('Please input a wallet address to continue');
        }
    } else {
        alertError(`The provided wallet address is not a Valid ${currency} address`)
    }
})

var isRealString = (str)=>{
    return typeof str === 'string' && str.trim().length > 0;
}

$('.email-change-form').submit(function(event){
    event.preventDefault()
    let emailId = document.getElementById('eamil-change-address').value;
    let atpos = emailId.indexOf("@");
    let dotpos = emailId.lastIndexOf(".");
    if($('#email-change-pass').val() < 1){
        alertError('Please input account password to proceed')
        return false
    } else if(atpos < 1 || ( dotpos - atpos < 2 )){
        alertError('Please input a correct email address!')
    } else {
        alertSuccess('Your request is being processed')
        $(this).ajaxSubmit({
            method: 'POST',
            error: function(error){
                alertError(error.responseText || 'Check your Internet Connection')
            },
            success: function(data){
                if(data.status === "error"){
                    alertError(data.message)
                } else {
                    alertSuccess(data)
                    $('#email').val(emailId)
                }
            }
        })
    }
    
})

function logChanger(urlInput,final){
    alertSuccess('Processing Email login notification')
    $.ajax({
        type: "POST",
        url: urlInput,
        success: function(data){
            if(data.status === "error"){
                alertError(data.message)
            } else {
                alertSuccess(data);
                if(final == 'Activated'){
                    jQuery('#valueEma').text('Deactivated')
                } else {
                    jQuery('#valueEma').text('Activated')
                }
            }
        }
    })
    .fail((err)=>{
        alertError(err.responseText || 'Check your Internet Connection');
    })
}


function payoutChanger(urlInput,final){
    console.log(urlInput);
    alertSuccess('Processing your payout mode request')
    $.ajax({
        type: "POST",
        url: urlInput,
        success: function(data){
            if(data.status === "error"){
                alertError(data.message)
            } else {
                alertSuccess(data);
                if(final == 'Manual mode'){
                    jQuery('#methodCurrent').text('Automatic mode')
                } else {
                    jQuery('#methodCurrent').text('Manual mode')
                }
            }
        }
    })
    .fail((err)=>{
        alertError(err.responseText || 'Check your Internet Connection');
    })
}



$(function(){
    jQuery('button#login-changer').on('click', function(){
        var current = $('#valueEma').text(),
            final   = jQuery.trim(current);
        if(final == 'Activated'){
            console.log("running on active")
            logChanger('/deactiveLogin',final)
        } else if(final == 'Deactivated') {
            logChanger('/activateLogin',final)
        } else {
            console.log('something went wrong')
        }
    })
    
    jQuery('button#payUpdaterPro').on('click', function(){
        var current = $('#methodCurrent').text(),
            final   = jQuery.trim(current);
            console.log(final)
        if(final == 'Manual mode'){
            console.log("running on active")
            payoutChanger('/dashboard/automaticpayout',final)
        } else if(final == 'Automatic mode') {
            payoutChanger('/dashboard/manualpayout',final)
        } else {
            console.log('something went wrong')
        }
    })
})

$('#formUpdate').submit(function(event){
    event.preventDefault()
    persoValidate($(this))
})

$('.investbut').on('click',function(){
    $('#sortInvest')[0].click()
})

function persoValidate(formOwner){
    var emailId = document.getElementById('email').value;
     var atpos = emailId.indexOf("@");
     var dotpos = emailId.lastIndexOf(".");
     var zipo   = document.getElementById('zip-code')
     var zipcode = /^\+?([0-9]{2})\)?[-. ]?([0-9]{4})[-. ]?([0-9]{4})$/;
    if (atpos < 1 || ( dotpos - atpos < 2 )){
         $('#show-to').fadeIn()
         $('#error-text').text('Email Address: please input a valid email address to continue ')
         return false;
    } else if($('#perso-focus').val() == '' || $('#name').val() == '' || $('#country').val() == '' || 
               $('#address').val() == '' || $('#zip-code').val() == '' || $('#phone').val() == '')
    {
        $('#show-to').fadeIn()
        $('#error-text').text('Form incomplete: Please note that all form inputs are needed')
        return false;
    } else if($('#zip-code').val().length < 4){
         alertError('Please ensure that your zip code is wriiten only in numbers and is valid')
         return false                     
    } else {
        alertSuccess('Profile updating: your profile info are been updated')
        $(formOwner).ajaxSubmit({
            error: function(error){
                alertError(error.responseText || `Check your Internet Connection`);
            },
            success: function(data){
                if(data.status === "error"){
                    alertError(data.message)
                } else {
                    alertSuccess('Profile updated: your profile info has been updated successfully')
                // window.location.href="/login"
                }
            }
            });
        }
        return false;
    }
    
jQuery('#ref-linko').on('click', ()=>{
    $('#ref-reveal').fadeToggle();
})

$(window).on('resize', function(){
      var win = $(this); //this = window
      if (win.width() <= 768) { 
          $('#perso').html( `<i class="fa fa-user"></i>` );
          $('#sett').html( `<i class="fa fa-cubes"></i>` );
          $('#payout').html( `<i class="fa fa-credit-card"></i>` );
      }
      if (win.width() >= 769) { 
        //   alert('hello there')
      }
});
