/* global $ WAValidator jQuery*/

let owner = document.getElementById('owner').innerText.trim()

function closeAlert() {
    $(".show-alert-message").fadeOut(1000);
}

$('.passcang').on('click', function(){
    $(this).parent().fadeOut( 200, function(){
        $('#fundsdep').fadeIn(200)
    })
})

$('#passInvert').on('click', function () {
    $('#fundsdep').fadeOut(200, function () {
        $('.passcang').parent().fadeIn(200)
    })
})

$('#vertEmail').click(()=>{
    $('.emailChange').fadeIn();
})

function hide(elementi,fadeback){
    $(elementi).fadeOut( function(){
        if (fadeback) {
            $(fadeback).parent().fadeIn();
        }
    });
}

$('#2faRev').on('click', function () {
    // let cutext = $(this).text()
    
    if($(this).hasClass('setup-fr')){
        alertSuccess('Wait, Generating Authentication key')
    	var ul = `/setup2fa/${owner}`
    	if(ul){
    		$.ajax({
    			url: ul,
    			method: 'GET',
    			error: function(error){
    				alertError(error.responseText || 'Check your internet connection')
    			},
    			success: function(data){
    			    console.log(data)
    				$('.twofa-sett img').attr('src', data.qrImage);
    				$('.keytin span').text(data.key);
    				alertSuccess('Key generated successfully!');
    				$('#2faRev').parent().fadeOut(200, function () {
                        $('.twofa-sett').fadeIn(200)
                    })
    			}
    		})
    	}
    } else if($(this).hasClass('disable-fr')){
        // alertSuccess('Wait, Disabling two-factor authentication..')
    // 	var ul = `/disable2fa/${owner}`
    	$('#2faRev').parent().fadeOut(200, function () {
            $('.disable2fac').fadeIn(200);
        })
    }
});

var isString = function(str){
	return typeof str === 'string' && str.trim().length > 0;
}

$('#disable_fac').click(function(){
	let code = jQuery('input[name="code"].secset').val();
	
	if(!isString(code)){
		console.log(code)
		alertError('Input your google 2fa code to continue');
		return false;
	} else {
		alertSuccess('Please wait, disabling 2FA...')
		$('form#disableupfac').ajaxSubmit({
			url: `/disable-otp/${owner}`,
			method: 'POST',
			error: function(error){
				alertError(error.responseText || 'Check your internet connection');
			},
			success: function(data){
			    console.log(data);
				$('.twofa-sett').fadeOut( ()=>{
				    $('#2faRev').removeClass('disable-fr').addClass('setup-fr').text('Enable').parent().fadeIn();
				    $('#2fa-status').text('2fa-Disabled').removeClass('badge-success').addClass('badge-danger')
				})
				alertSuccess(data.message);
			}
		})
		return false;
	}
})

$('#activate_fac').click(function(){
	let code = jQuery('input[name="code"].fistset').val();
	
	if(!isString(code)){
		console.log(code)
		alertError('Input generated code from google authenticator');
		return false;
	} 
	if (document.getElementById('2facheck').checked != true) {
		alertError(`To continue, accept that you've written down your key`);
		return false;
	} else{
		alertSuccess('Please wait, authenticating...')
		$('form#setinupfac').ajaxSubmit({
			url: `/login-otp/${owner}`,
			// url: `/login-otp/5ef0b5d3ac1bd32b18d04c4f`,
			method: 'POST',
			error: function(error){
				alertError(error.responseText || 'Check your internet connection');
			},
			success: function(data){
			    console.log(data);
				$('.twofa-sett').fadeOut( ()=>{
				    $('#2faRev').removeClass('setup-fr').addClass('disable-fr').text('Disable').parent().fadeIn();
				    $('#2fa-status').text('2fa-Enabled').removeClass('badge-danger').addClass('badge-success')
				})
				alertSuccess(data.message);
			}
		})
		return false;
	}
})

$('#logOuter').on('click', function () {
    $(this).parent().fadeOut(200, function () {
        $('#logForm').fadeIn(200)
    })
})

$('#fundsdep').submit(function(event){
    event.preventDefault()
    Passwordvalidate()
})

function Passwordvalidate(){
    let current = document.getElementById('sett-focus').value;
    let newpass = document.getElementById('newpass').value;
    let confirm = document.getElementById('confirm-pass').value;
    
    if(current == '' || newpass !== confirm){
        alertError('Request denied: Your passowrds do not match each other, try again')
        return false
    } else if($('#newpass').val().length < 6){
        alertError('Request denied: Your passowrd should be more than six characters')
        return false
    } else{
        alertSuccess('Updating your Account Password..')
        $.post(`/updatepass/${owner}`,{
            currentpass: current,
            password: newpass,
            confirmPassword: confirm
        }, function(data, status){
            console.log(data, status)
            if(data.status === "error"){
                alertError(data.message)
            } else {
                alertSuccess(data)
                if(data == 'Authorized: Your password has been changed successfully'){
                    document.getElementById('sett-focus').value = "";
                    document.getElementById('newpass').value = "";
                    document.getElementById('confirm-pass').value = "";
                    $('#fundsdep').fadeOut(200, ()=>{
                        $('.passcang').parent().fadeIn()
                    })
                }
            }
        })
        .fail(function(error) {
            alertError(error.responseText || 'Check your Internet Connection');
        })
        
    }
    return false;
}

function alertError(message){
    $('#show-to-success').fadeOut(function(){
        $('#show-to').fadeIn()
        $('#error-text').text(message)  
    })
}

function alertSuccess(message){
    $('#show-to').fadeOut(function(){
        $('#show-to-success').fadeIn()
        $('#success-text').text(message)  
    })
}

$('#updatEmail').submit(function(event){
    event.preventDefault()
    let emailId = document.getElementById('email-change-address').value;
    let atpos = emailId.indexOf("@");
    let dotpos = emailId.lastIndexOf(".");
    if($('#email-change-pass').val() < 1){
        alertError('Please input account password to proceed')
        return false
    } else if(atpos < 1 || ( dotpos - atpos < 2 )){
        alertError('Please input a correct email address!')
    } else {
        alertSuccess('Your request is being processed')
        $(this).ajaxSubmit({
            method: 'POST',
            error: function(error){
                alertError(error.responseText || 'Check your Internet Connection')
            },
            success: function(data){
                if(data.status === "error"){
                    alertError(data.message)
                } else {
                    alertSuccess(data)
                    $('#email-change-pass,#email-change-address').val('')
                    $('#emailup').text(emailId)
                }
            }
        })
    }
    
})

$(function(){
    jQuery('button#login-changer').on('click', function(){
        var current = $(this).text(),
            final   = jQuery.trim(current);
            console.log(final)
        if(final == 'Disable'){
            console.log("running on active")
            logChanger('/deactiveLogin',final)
        } else if(final == 'Enable') {
            // console.log('hiy')
            logChanger('/activateLogin',final)
        } else {
            console.log('something went wrong')
        }
    })
})

function logChanger(urlInput,final){
    alertSuccess('Processing Email login notification')
    $.ajax({
        type: "POST",
        url: urlInput,
        success: function(data){
            if(data.status === "error"){
                alertError(data.message)
            } else {
                alertSuccess(data);
                if(final == 'Disable'){
                    jQuery('button#login-changer').text('Enable')
                    $('#valueEmalog').removeClass('badge-success').addClass('badge-danger').text('Disabled')
                } else if(final == 'Enable') {
                    jQuery('button#login-changer').text('Disable')
                    $('#valueEmalog').removeClass('badge-danger').addClass('badge-success').text('Enabled')
                }
            }
        }
    })
    .fail((err)=>{
        alertError(err.responseText || 'Check your Internet Connection');
    })
}
