/* global $ WAValidator jQuery*/

function closeAlert() {
    $(".show-alert-message").fadeOut(1000);
}

$(document).ready(function () {
    
  $('#dtBasicExample').DataTable({
    "paging": true,
    "pagingType": "full_numbers",
    // "searching": false,
    "order": [[ 5, "asc" ]],
    "ordering": true,
    "lengthMenu": [[5, 10, 25, 50, -1], [5, 10, 25, 50, "All"]]
  });
  $('.dataTables_length').addClass('bs-select');
  
  $('#historyMain').DataTable({
    "order": [[ 5, "asc" ]],
    "lengthMenu": [[5, 10, 25, 50, -1], [5, 10, 25, 50, "All"]],
    "pagingType": "full_numbers",
  })
  
  $('#tradeMain').DataTable({
    "order": [[ 5, "asc" ]],
    "lengthMenu": [[5, 10, 25, 50, -1], [5, 10, 25, 50, "All"]],
    "pagingType": "full_numbers",
  })
  
  $('#referralMain').DataTable({
    "order": [[ 5, "asc" ]],
    "lengthMenu": [[5, 10, 25, 50, -1], [5, 10, 25, 50, "All"]],
    "pagingType": "full_numbers"
  })
  
});

// function copyFunction() {
  
//   var range = document.createRange();
//   range.selectNode(document.getElementById("myReffLink"));
//   window.getSelection().removeAllRanges(); // clear current selection
//   window.getSelection().addRange(range); // to select text
//   document.execCommand("copy");
//   window.getSelection().removeAllRanges();// to deselect
  
//     var tooltip = document.getElementById("myTooltip");
//     tooltip.innerHTML = "Copied Ref-ID";
// }

function copyFunction(tocopy,mainto,copio) {
  
  var range = document.createRange();
  range.selectNode(document.getElementById(tocopy));
  window.getSelection().removeAllRanges(); // clear current selection
  window.getSelection().addRange(range); // to select text
  document.execCommand("copy");
  window.getSelection().removeAllRanges();// to deselect
  
    var tooltip = document.getElementById(mainto);
    tooltip.innerHTML = copio;
}
  
  function outFunc(mainto) {
    var tooltip = document.getElementById(mainto);
    tooltip.innerHTML = "Copy to clipboard";
}


function alertError(message){
    $('#show-to-success').fadeOut(function(){
        $('#show-to').fadeIn()
        $('#error-text').text(message)  
    })
}

function alertSuccess(message){
    $('#show-to').fadeOut(function(){
        $('#show-to-success').fadeIn()
        $('#success-text').text(message)  
    })
}

function allAmountNfp(amount,value){
    console.log('export')
    $(value).val(amount);
}

function allAmount(){
    console.log('here')
    let amount = $('#checkprofitval').text();
    console.log(amount);
    $('.reff-amount-withdraw').val(amount);
}

$('#popPayWindow').on('click', function(){
    $('.withdrawfunds').fadeIn(500);
})

$('#popDeposit').on('click', function(){
    $('.depositfunds').fadeIn(500);
})

$('#popExport').on('click', function(){
    $('.exportfunds').fadeIn(500);
})

$('#popImport').on('click', function(){
    $('.importfunds').fadeIn(500);
})

$('.controlout').click(()=>{
    $('.withdrawfunds,.depositfunds,.exportfunds,.importfunds').fadeOut(500);
})

$('#withdrawSubmit').submit(function(event){
    event.preventDefault()
    let address = $('#walletaddress').val(),
        pass    = document.getElementById('pass').value
        
    var valid = WAValidator.validate(address, 'ETH', 'both');
    if(valid){
        if(pass.length < 1){
            alertError('Please input your password to continue')
        } else {
            $("#san-button").attr("disabled","disable");
            alertSuccess('Request processing: your request for withdrawal is been processed')
            $(this).ajaxSubmit({
                error: function(data){
                    console.log(data)
                    $("#san-button").removeAttr("disabled");
                    alertError(data.responseText || 'Check your Internet Connection')
                },
                success: function(data){
                   $("#san-button").removeAttr("disabled");
                   if(data.status === "error"){
                       alertError(data.message)
                   } else {
                        alertSuccess(data)
                        jQuery('.withdrawfunds').fadeOut()
                        $('input').val('');
                        
                   }
                }
            })
        }
    } else {
        alertError('Invalid address');
    }
    return false;
})

$('#withdrawNfp').submit(function(event){
    // event.preventDefault()
    let address = $('#walletaddress').val();
    var valid = WAValidator.validate(address, 'BTC', 'both');
    if(valid){
        return $(this).submit()
    } else {
        alertError('Invalid Bitcoin address');
    }
    return false;
})


// $('#depNfp').submit(function(event){
//     event.preventDefault()
//     let amount = $('.nfpInvest').val();
//     console.log(amount)
    
//     return false;
// })

// function addCommas(nStr,elem){
//  nStr += '';
//  var x = nStr.split('.');
//  var x1 = x[0];
//  var x2 = x.length > 1 ? '.' + x[1] : '';
//  var rgx = /(\d+)(\d{3})/;
//  while (rgx.test(x1)) {
//   x1 = x1.replace(rgx, '$1' + ',' + '$2');
//  }
//  let final =  x1 + x2;
//  elem.text(final)
// }

// function currency(n,elem){
//     n=parseFloat(n);
//     let fin = isNaN(n)?false:n.toFixed(2);
//     console.log(fin)
//     // elem.text(fin)
//     addCommas(fin,elem)
// }

// $('.numCurrency').each(function(){
//     let num = $(this).text();
//     currency(num,$(this))
// })