/* global $ WAValidator jQuery*/

function closeAlert() {
    $('.show-alert-message').fadeOut(1000);
}

function closeOutCon(){
    jQuery('.checkout').fadeOut(function(){
        jQuery('.success-confirm').fadeOut();
    })
}
var audio = new Audio('/assets/audio/censor-beep-01.mp3')

function alertError(message){
    $('#show-to-success').fadeOut(function(){
        $('#show-to').fadeIn()
        $('#error-text').text(message)  
    })
}

function alertSuccess(message){
    $('#show-to').fadeOut(function(){
        $('#show-to-success').fadeIn()
        $('#success-text').text(message)  
    })
}

// const ownerWith = document.getElementById('owner-with').innerText
const plan = document.getElementById('planner').innerText

$('.payout-form').submit(function(event){
    let paid = $(this).find('.form-control').val()
    console.log(paid)
    // console.log($('#investcheck').text())
    if($('#investcheck').text() == 'active'){
        if(paid < 10){
            alertError(`The given amount is less than the minimum amount for top up ($100)`)
        } else if(paid >9) {
            return true
        }
    } else if (paid < 1000){
        alertError(`The given amount is less than your ${plan} plan minimum deposit`)
        return false
    } else if(plan === 'starter'){
        if(paid > 9999){
            alertError(`The given amount is more than your ${plan} plan maximum deposit`)
        } else {
            return true
        }
        
    } else if (plan === "economy") {
        
        if(paid < 10000){
            
            alertError(`The given price is less than your ${plan} plan minimum deposit`)
        } else if(paid > 19999) {
            alertError(`The given price is more than your ${plan} plan maximum deposit`)
        } else{return true}
        
    }else if(plan === 'business'){
        if(paid < 20000){
            alertError(`The given price is less than your ${plan} plan minimum deposit`)
        } else if(paid > 49999) {
            alertError(`The given price is more than your ${plan} plan maximum deposit`)
        } else{return true}
        
    } else if(plan === 'first-class'){
        if(paid < 50000){
           alertError(`The given price is less than your ${plan} plan minimum deposit`)
        } else if(paid > 99999) {
           alertError(`The given price is more than your ${plan} plan maximum deposit`)
        } else{return true}
    } else if(plan === 'executive'){
        if(paid < 100000){
           alertError(`The given price is less than your ${plan} plan minimum deposit`)
        } else {
            return true
        }
    }
    
    return false;
})

var isRealString = (str)=>{
    return typeof str === 'string' && str.trim().length > 0;
}
var isRealNumber = (number)=>{
    return typeof number === 'number' && number.trim().length > 0;
}

function currencyChange(){
    console.log(document.getElementById('soflow').value)
}

$('.withdraw').submit( function (event){
    // alert(currency)
    event.preventDefault()
    // validate()
    let address = document.getElementById('coinAddress').value;
    let amount  = document.getElementById('amount-with').value,
        pass    = document.getElementById('pass').value,
        currency= document.getElementById('soflow').value
        
        console.log(currency)
    
    var valid = WAValidator.validate(address, currency);
    if(valid){
        if(address.length < 10){
        alertError(`Please input a valid crypto address!`)
        } else if(isNaN(amount) || amount < 1){
            return alertError(`Please note that withdrawal amount must be greater than 15 USD`)
        } else if(pass.length < 1){
            alertError('Please input your password to continue')
        } else {
            $("#san-button").attr("disabled","disable");
            alertSuccess('Request processing: your request for withdrawal is been processed')
            $(this).ajaxSubmit({
                error: function(data){
                    console.log(data)
                    $("#san-button").removeAttr("disabled");
                    alertError(data.responseText || 'Check your Internet Connection')
                },
                success: function(data){
                   $("#san-button").removeAttr("disabled");
                   if(data.status === "error"){
                       alertError(data.message)
                   } else {
                        audio.play()
                        alertSuccess(data)
                        jQuery('.confirm-action').fadeOut(()=>{
                            jQuery('.success-confirm').fadeIn()
                        })
                        $('input').val('');
                        // if(data == 'A mail has been sent to your account with further Instructions'){
                        //     document.getElementById('amount-with').value = ""
                        //     document.getElementById('coinAddress').value = "";
                        //     document.getElementById('pass').value = "";
                        // }
                   }
                }
            })
        }
    } else {
        alertError(`Please input a Valid ${currency} address`)
    }
    return false;
})

var userid = $('.iduser').text();

$('#withdrawcapi').click(function(){
    // console.log('working')
    $.ajax({
      url: `/withdrawcap/${userid}`,
    })
})

$('#reinvestcapi').click(function(){
    // console.log('working')
    $.ajax({
      url: `/reinvestcap/${userid}`,
    })
})

function validate() {
	var valid = true;
	
	valid = checkEmpty($("#amount-with"));
    valid = checkEmpty($("#coinAddress"));
    valid = checkEmpty($("#pass"));
    $("#san-button").attr("disabled",true);
	if(valid) {
		$("#san-button").attr("disabled",false);
	}
}
function checkEmpty(obj) {
	var name = $(obj).attr("name");
	$("."+name+"-validation").html("");	
	$(obj).css("border","");
	if($(obj).val() == "") {
		$("."+name+"-validation").html("Required");
		return false;
	}
	return true;	
}