/* global $ Chartist */
$(function() {
    "use strict";
    // ============================================================== 
    // Newsletter
    // ============================================================== 

    var chart = new Chartist.Line('.campaign', {
        labels: [1, 2, 3, 4, 5, 6, 7, 8],
        series: [
            [0, 5, 6, 8, 25, 9, 8, 24],
            [0, 3, 1, 2, 8, 1, 5, 1]
        ]
    }, {
        low: 0,
        high: 28,

        showArea: true,
        fullWidth: true,
        plugins: [
            Chartist.plugins.tooltip()
        ],
        axisY: {
            onlyInteger: true,
            scaleMinSpace: 40,
            offset: 20,
            labelInterpolationFnc: function(value) {
                return (value / 1) + 'k';
            }
        },

    });

    // Offset x1 a tiny amount so that the straight stroke gets a bounding box
    // Straight lines don't get a bounding box 
    // Last remark on -> http://www.w3.org/TR/SVG11/coords.html#ObjectBoundingBox
    chart.on('draw', function(ctx) {
        if (ctx.type === 'area') {
            ctx.element.attr({
                x1: ctx.x1 + 0.001
            });
        }
    });

    // Create the gradient definition on created event (always after chart re-render)
    chart.on('created', function(ctx) {
        var defs = ctx.svg.elem('defs');
        defs.elem('linearGradient', {
            id: 'gradient',
            x1: 0,
            y1: 1,
            x2: 0,
            y2: 0
        }).elem('stop', {
            offset: 0,
            'stop-color': 'rgba(255, 255, 255, 1)'
        }).parent().elem('stop', {
            offset: 1,
            'stop-color': 'rgba(64, 196, 255, 1)'
        });
    });


    var chart = [chart];
});

function loadData(){
    $.get('https://min-api.cryptocompare.com/data/price?fsym=BTC&tsyms=USD,EUR&api_key=7eb7e9eebec62aa237438e784fa07de4f98ac338b70038fa17bde0665801330c')
    .done(function(data){
        let fixed = data.USD.toFixed()
        console.log(data)
        // $('#perbtc').text(fixed);
        addCommas(fixed,$('#perbtc'))
    });
    
    $.get('https://min-api.cryptocompare.com/data/price?fsym=ETH&tsyms=USD,EUR&api_key=7eb7e9eebec62aa237438e784fa07de4f98ac338b70038fa17bde0665801330c')
    .done(function(data){
        let fixed = data.USD.toFixed(1)
        // $('#pereth').text(fixed);
        addCommas(fixed,$('#pereth'))
    })
}

setInterval(function(){
    loadPercent();
},300000)

function percent(coin,dom){
    if(coin.charAt(0) == '-'){
        let extension = coin + '%'
        dom.text(extension).removeClass('text-success').addClass('text-danger')
    } else {
        let extension = coin + '%'
        dom.text(extension).removeClass('text-danger').addClass('text-success')
    }
}

function loadPercent(){
    // $.get('https://api.coinmarketcap.com/v2/ticker/?limit=10')
    $.get('https://min-api.cryptocompare.com/data/pricemultifull?fsyms=BTC,ETH&tsyms=USD&api_key=7eb7e9eebec62aa237438e784fa07de4f98ac338b70038fa17bde0665801330c')
    .then(function(data){
        let percentages = [data.RAW.BTC.USD.CHANGEHOUR.toFixed(2), data.RAW.ETH.USD.CHANGEHOUR.toFixed(2)]
        const btcPercent = percentages[0].toString(),
              ethPercent = percentages[1].toString()
        if(btcPercent){percent(btcPercent,$('#btc-percent'))}
        if(ethPercent){percent(ethPercent,$('#eth-percent'))}
    })
}

$(function(){
    loadPercent();
    loadData();
})

setInterval(function(){
    loadData();
    currencyChange1();
},300000);

function currencyChange1(){
    var coin = document.getElementById('selected_coin').value
    
    $.get(`https://min-api.cryptocompare.com/data/pricemulti?fsyms=BTC,ETH,LTC,BCH&tsyms=${coin}&api_key=7eb7e9eebec62aa237438e784fa07de4f98ac338b70038fa17bde0665801330c`)
    .then(function(data){
        
        addCommas(Object.values(data.BTC)[0], $('#btc-price'));addCommas(Object.values(data.LTC)[0], $('#ltc-price'));addCommas(Object.values(data.ETH)[0], $('#eth-price'));addCommas(Object.values(data.BCH)[0], $('#bch-price'));
        if(coin == 'USD'){
            $('.currency-sign').text('$')
        } else if(coin == 'EUR'){
            $('.currency-sign').text('€')
        } else {
            $('.currency-sign').text('Ƀ')
        }
    })
}

// apikey: 1363cb6ff238a7d2b52eb2c151e8aad86f340de865d0d550b993b4d447ed8bcf

function loadTableData(){
    $.get(`https://min-api.cryptocompare.com/data/pricemultifull?fsyms=BTC,USDT,LTC,ETH,BCH&tsyms=USD&api_key=7eb7e9eebec62aa237438e784fa07de4f98ac338b70038fa17bde0665801330c`)
    .then(function(data){
        let btc = data.RAW.BTC.USD,
            eth = data.RAW.ETH.USD,
            ltc = data.RAW.LTC.USD,
            bch = data.RAW.BCH.USD,
            usdt = data.RAW.USDT.USD
            
        let changeBtc = btc.CHANGE24HOUR.toFixed(1), changeEth = eth.CHANGE24HOUR.toFixed(1), changeLtc = ltc.CHANGE24HOUR.toFixed(1), changeBch =bch.CHANGE24HOUR.toFixed(1);
            
        runDom('#low-btc', btc.LOWDAY);runDom('#high-btc', btc.HIGHDAY);runDom('#last-btc',btc.LASTMARKET);runDom('#flag-btc',btc.FLAGS);runDom('#change-btc',changeBtc);
        runDom('#low-eth', eth.LOWDAY);runDom('#high-eth', eth.HIGHDAY);runDom('#last-eth',eth.LASTMARKET);runDom('#flag-eth',eth.FLAGS);runDom('#change-eth',changeEth);
        runDom('#low-ltc', ltc.LOWDAY);runDom('#high-ltc', ltc.HIGHDAY);runDom('#last-ltc',ltc.LASTMARKET);runDom('#flag-ltc',ltc.FLAGS);runDom('#change-ltc',changeLtc);
        runDom('#low-bch', bch.LOWDAY);runDom('#high-bch', bch.HIGHDAY);runDom('#last-bch',bch.LASTMARKET);runDom('#flag-bch',bch.FLAGS);runDom('#change-bch',changeBch);
        runDom('#low-usdt', bch.LOWDAY);runDom('#high-usdt', bch.HIGHDAY);runDom('#last-usdt',bch.LASTMARKET);runDom('#flag-usdt',usdt.FLAGS)
        
        changePer(changeLtc,'#change-ltc');changePer(changeBtc,'#change-btc');changePer(changeEth,'#change-eth');changePer(changeBch,'#change-bch');
    })
}

function changePer(varo,dom){
    if(varo.charAt(0) == '-'){
        $(dom).css({color: '#f62d51'})
    }
}

function runDom(selector,val){
    $(selector).text(val);
}

$(function(){
    loadTableData()
    currencyChange1()
})

setInterval(function(){
    loadTableData();
},300000);

