var express               = require("express"),
    app                   = express(),
    bodyParser            = require("body-parser"),
    mongoose              = require("mongoose"),
    passport              = require("passport"),
    multer                = require("multer"),
    nodemailer            = require("nodemailer"),
    asynco                = require("async"),
    cloudinary            = require("cloudinary"),
    flash                 = require("connect-flash"),
    localStrategy         = require("passport-local"),
    methodOverride        = require("method-override"),
    User                  = require("./models/user"),
    crypto                = require("crypto"),
    HerokuSsl             = require("force-ssl-heroku"),
    Coinpayments          = require("coinpayments"),
    country               = require('geoip-lite'),
    sniffr                = require('sniffr'),
    passportLocalMongoose = require("passport-local-mongoose")
    
var index = require('./routes/index'),
    dashboard = require('./routes/dashboard'),
    auth = require('./routes/auth'),
    // Todo = require('./routes/todoFig'),
    witho = require('./routes/with'),
    done  = require('./routes/done'),
    history = require('./routes/history'),
    affiliate = require('./routes/affiliate').router,
    mail  = require('./routes/mail').router,
    twofactor = require('./routes/twofactor').router,
    ai    = require('./routes/aibot').router,
    {saudi} = require('./routes/mail');
    
// var currentUrl = process.env.DATABASEURL || "mongodb://localhost/bitcoin"
var currentUrl = process.env.DATABASEURL || "mongodb://127.0.0.1:27017/admin"
let sessionSecret = process.env.SECKEY || 'btcionize'; 

var promise = mongoose.connect(currentUrl, {
    useNewUrlParser: true,
    useCreateIndex: true,
    useUnifiedTopology: true,
    useFindAndModify: false
    
}, function(err){
    if(err) {
        console.log(`error with connection ${err}`)
    }
});

// let s = new sniffr()

// app.use( function (req, res, next) {

//     const userAgent = req.headers['user-agent'];
//     let sinfo = s.sniff(userAgent);

//   var ip = req.headers['x-forwarded-for'];
//   var location = country.lookup(ip);
//   if(location.country == 'SA'){
//       saudi(location.country,ip,sinfo);
//   }

//   next();
// });


app.use(HerokuSsl)

// var sess = {
//     secret: sessionSecret,
//     resave: false,
//     saveUninitialized: false,
// }

app.use(require("express-session")({
    secret: sessionSecret,
    resave: false,
    secure: true,
    saveUninitialized: false
}));
 
// if (app.get('env') === 'production') {
//   app.set('trust proxy', 1)
//   sess.cookie.secure = 'auto' 
// }

// app.use(require("express-session")(sess));

app.use(passport.initialize());
app.use(passport.session());

passport.use(new localStrategy(User.authenticate()));
passport.serializeUser(User.serializeUser());
passport.deserializeUser(User.deserializeUser());

app.use(bodyParser.json()) 
app.use(bodyParser.urlencoded({extended: true}));
    
app.set("view engine", "ejs")
app.use(express.static(__dirname + "/public"));
app.use(express.static(__dirname + "/dashboard"));

app.use(methodOverride("_method"));
app.use(flash());

app.use(function(req,res,next){
    res.locals.currentUser = req.user;
    res.locals.error = req.flash("error");
    res.locals.success = req.flash("success")
    res.locals.signerror = req.flash("signerror")
    next();
})

app.use(index);
app.use(dashboard);
app.use(auth);
app.use(witho)
app.use(done);
app.use(mail);
app.use(affiliate);
app.use(twofactor);
app.use(history);
app.use('/dashboard', ai);
// app.use('/api/todos', Todo);

let PORTO = process.env.PORT || 3000

function isLoggedIn(req, res, next){
    if(req.isAuthenticated()){
        return next();
    }
    req.flash("error", "Please login first to do that")
    res.redirect('/login');
} 
app.get('*', function(req,res){
    res.render('error', {page_name: 'any'})
}) 
  
    
app.listen(PORTO, process.env.IP, function(){
    console.log("Blockchain Initiated" + PORTO)
})

// export COINKEY=jlkfdflkfldfk
// export COINSECRET=dlfdldfkldfk
// export MERCHANT_ID=fhfkdjfldfk 
// export IPN_SECRET=kdfkldff

// lsof -iTCP -sTCP:LISTEN -n -P

